import InfoTooltip from "../InfoTooltip.js";
import MeaningComponent from "./MeaningComponent.js";

export default {
    props: {
        frame: Object,
    },
    components: {InfoTooltip, MeaningComponent},
    emits: ['frameSelectionChanged'],
    data() {
        return {
            img_prefix: String,
            selectedLus: null
        }
    },
    methods: {
        getTitleHTML() {
            const ret = window.lexical_units2dom(this.frame.lexical_units);
            return ret;
        },
        getOpinionHTML() {
            return window.make_opinion_row(this.frame, this.frame.arguments.length, 3).outerHTML;
        },
        getArguments() {
            return this.frame.arguments;
        },
        triggerSelectedEvent() {
            const selectedLus = this.frame.lexical_units.filter(lu => lu.selected);
            const selectedArguments = this.frame.arguments.filter(argument => argument.selected)
            this.$emit('frameSelectionChanged', selectedArguments, selectedLus);
        },
        meaningLuSelected(selectedLus) {
            this.triggerSelectedEvent();
        },
        selectArgument(argument) {
            argument.selected = !argument.selected;
            this.triggerSelectedEvent();
        }
    },
    mounted () {
        this.img_prefix = window.STATIC_URL;
    },
    template: `
        <div class="frame mb-3 active">
            <div class="frame mt-0" id="lexical-unit">
                <meaning-component
                    :lexicalUnits="frame.lexical_units"
                    @meaning-lu-selected="meaningLuSelected"
                ></meaning-component>
            </div>
            <table class="table m-0 table-borderless border border-secondary text-dark">
                <tbody>
                    <tr class="opinion-row" v-html="getOpinionHTML()">
                    </tr>
                    <tr>
                        <th scope="row" class="py-2 px-1 text-secondary">Rola</th>
                        <template v-for="argument in frame.arguments">
                            <td class="argument py-2 px-1 border-top border-left border-secondary" 
                                @mouseenter="argument.hover=true"
                                @mouseleave="argument.hover=false"
                                @click.stop="selectArgument(argument)"
                                :class="argument.role + ' ' + (argument.selected ? 'active' : argument.hover ? 'bg-highlight' : '')" 
                            >
                                {{argument.str}}
                            </td>
                        </template>
                    </tr>
                    <tr>
                        <th scope="row" class="py-0 px-1 text-secondary">Preferencje selekcyjne</th>
                        <template v-for="argument in getArguments()">
                        
                        <td class="preferences py-0 px-0 border-top border-left border-secondary"
                            :class="argument.selected ? 'active' : argument.hover ? 'bg-highlight' : ''" 
                        >
                            <template v-if="argument.preferences.length > 0" v-for='preference in argument.preferences'>
                                <div
                                  v-if="preference.url != null"
                                  class="preference py-2 px-1"
                                >
                                  <a class="synset-plwn" v-bind:href="preference.url" target="_blank">{{ preference.str }}</a>
                                  <info-tooltip v-if="preference.info" :text="'definicja: <i>'+ preference.info +'</i>'" />
                                </div>
                                <div v-else class="preference py-2 px-1">{{ preference.str }}</div>
                            </template>
                            </td>
                        </template>
                    </tr>
                </tbody>
            </table>
        </div>
  `
}


