import InfoTooltip from "../InfoTooltip.js";

export default {
  props: {
    lexicalUnits: Object,
  },
  emits: ['meaningLuSelected'],
  data () {
    return {
      iconUrl: window.STATIC_URL + 'common/img/ext-link.svg'
    }
  },
  components: {InfoTooltip},
  methods: {
    getTooltipStr (lu) {
      const tooltip = [];
      if (lu.definition) {
        tooltip.push(lu.definition);
      }
      if (lu.gloss) {
        tooltip.push(lu.gloss);
      }
      if (!lu.url) {
        tooltip.push(gettext('nowa jednostka spoza <i>Słowosieci</i>'));
      }
      return tooltip.length > 0 ? '<i>' + tooltip.join('; ') + '</i>' : null;
    },
    select(lexicalUnit) {
      lexicalUnit.selected = !lexicalUnit.selected;
      this.$emit('meaningLuSelected', this.lexicalUnits.filter(lexicalUnit => lexicalUnit.selected));
    }
  },
  template: `
    <p class="mb-1">
        <template v-for="lexicalUnit in lexicalUnits">
            <span
                @mouseenter="lexicalUnit.hover=true"
                @mouseleave="lexicalUnit.hover=false"
                @click.stop="select(lexicalUnit)"
                :class="lexicalUnit.selected ? 'entry-meaning active' : lexicalUnit.hover ? 'entry-meaning active' : ''" 
                class="lexical-unit entry-meaning" style="padding-left: 4px; padding-right: 4px;">{{lexicalUnit.str}}</span> 
            <info-tooltip v-if="getTooltipStr(lexicalUnit)" :text="getTooltipStr(lexicalUnit)"/>
            <a v-if="lexicalUnit.url" class="lu-plwn" style="padding-left: 4px;" :href="lexicalUnit.url" target="_blank">
                <img :src="iconUrl" alt="external link" height="14">
            </a>
        </template>
    </p>
  `
}
