import InfoTooltip from "../InfoTooltip.js";

export default {
    props: {
        examples: Object,
        frame: Object,
        frame_arguments: Object,
        frame_arguments_or_type: null,
        schemas: Object,
        lus: Object,
    },
    components: {InfoTooltip},
    data() {
        return {
            img_prefix: String
        }
    },
    methods: {
        getExamples () {
            let ret = this.examples;
            if(this.schemas && this.schemas.length > 0) {
                // ograniczone do schematu
                ret = ret.filter(e => this.schemas.every(a => e.schema_ids.includes(parseInt(a.id))));
            }
            if(this.frame_arguments && this.frame_arguments.length > 0) {
                // ograniczone do argumentu ramy
                if(this.frame_arguments_or_type) {
                    ret = ret.filter(e => this.frame_arguments.some(a => e.argument_ids.includes(a.id)));
                } else {
                    ret = ret.filter(e => this.frame_arguments.every(a => e.argument_ids.includes(a.id)));
                }
            }
            if(this.frame) {
                ret = ret.filter(e => e.frame_ids.includes(this.frame.id));
            }
            if(this.lus && this.lus.length > 0) {
                ret = ret.filter(e => this.lus.every(lu => e.lu_ids.includes(lu.id)));
            }
            return ret;
        },
        getSchemaStr(schema) {
            return schema.positions.map(e => e.phrases.map(p => p.str).join(",")).join('|');
        }
    },
    mounted () {
        this.img_prefix = window.STATIC_URL;
    },
    template: `
    <table id="semantics-examples" v-if="getExamples().length > 0" class="table table-sm table-hover" style="">
        <thead>
        <tr>
            <th scope="col">Przykład
                <i v-if="frame_arguments" v-for="frame_argument in frame_arguments">
                    <span class="example-role"> {{' '}}
                        <span :class="frame_argument.role">{{frame_argument.role}}</span>
                    </span>
                </i>
                <i v-if="lus" v-for="lu in lus">{{' ' + lu.str}}</i>
                <i v-if="schemas" v-for="schema in schemas">{{' '+getSchemaStr(schema)}}</i>
            </th>
            <th scope="col">Źródło</th>
            <th scope="col">Opinia</th>
        </tr>
        </thead>
        <tbody id="semantics-examples-list">
        
            <tr v-for="example in getExamples()" class="example">
                <td class="py-1">
                    {{example.sentence}}
                    <info-tooltip v-if="example.note" :text="example.note" />
                </td>
                <td class="py-1">{{example.source}}</td>
                <td class="py-1">{{example.opinion}}</td>
            </tr>
        
        </tbody>
    </table>
    <p v-else class="mx-1 my-1" id="semantics-no-examples" style="display: none;">Brak przykładów</p>
  `
}


