export default {
  props: {
    initialUnifiedFrameId: Number,
    unificationEntriesListRefreshKey: Number,
  },
  data () {
    return {
      gettext: window.gettext,
      canViewAssignment: has_permission("users.view_assignment")
    }
  },
  watch: {
    unificationEntriesListRefreshKey() {
      // TODO: reload data and click in selected row
      // this.datatableObject.ajax.reload();
      setup_frames_list({
        table: this.$refs.table,
        unifiedFrameSelected: (unifiedFrameId) => { this.$emit('unifiedFrameSelected', unifiedFrameId); },
        selectEntryId: this.initialEntryId,
      });
    }
  },
  emits: ['unifiedFrameSelected'],
  mounted () {
    setup_frames_list({
      table: this.$refs.table,
      unifiedFrameSelected: (unifiedFrameId) => { this.$emit('unifiedFrameSelected', unifiedFrameId); },
      selectEntryId: this.initialUnifiedFrameId,
    });
  },
  template: `
    <table ref="table" class="table table-sm table-hover text-dark">
      <thead>
        <tr>
          <th class="p-1">{{ gettext('Rama') }}</th>
          <th class="p-1">{{ gettext('Status') }}</th>
          <th v-if="canViewAssignment" class="p-1">{{ gettext('Leksykograf') }}</th>
          <th class="p-1" hidden="true">{{ gettext('Id') }}</th>
        </tr>
      </thead>
      <tbody id="entries">
      </tbody>
    </table>
  `
};
