export default {
  props: {
    initialLexicalUnitId: Number,
    initialEntryId: Number,
    unificationEntriesListRefreshKey: Number,
  },
  watch: {
    unificationEntriesListRefreshKey() {
      // TODO: reload data and click in selected row
      // this.datatableObject.ajax.reload();
      setup_entries_list({
        table: this.$refs.table,
        lexicalUnitSelected: (entryId, lexicalUnitId) => { this.$emit('lexicalUnitSelected', entryId, lexicalUnitId); },
        selectEntryId: this.initialEntryId,
        secondarySelectEntryId: this.initialLexicalUnitId,
      });
    }
  },
  data () {
    return {
      gettext: window.gettext,
      canViewAssignment: has_permission("users.view_assignment"),
    }
  },
  emits: ['lexicalUnitSelected'],
  mounted () {
    setup_entries_list({
      table: this.$refs.table,
      lexicalUnitSelected: (entryId, lexicalUnitId) => { this.$emit('lexicalUnitSelected', entryId, lexicalUnitId); },
      selectEntryId: this.initialEntryId
    });
  },
  template: `
    <table ref="table" class="table table-sm text-dark">
      <thead>
        <tr>
          <th class="p-1">{{ gettext('Lemat') }}</th>
          <th class="p-1">{{ gettext('Część mowy') }}</th>
          <th class="p-1">{{ gettext('Do pobrania') }}</th>
          <th v-if="canViewAssignment" class="p-1">{{ gettext('Semantyk') }}</th>
          <th v-else class="p-1">{{ gettext('Moje (w opracowaniu)') }}</th>
        </tr>
      </thead>
      <tbody id="entries">
      </tbody>
    </table>
  `
};
