export default {
  props: {
    initialLexicalUnitId: Number,
    initialEntryId: Number,
    unificationEntriesListRefreshKey: Number,
  },
  data () {
    return {
      gettext: window.gettext,
      canViewAssignment: has_permission("users.view_assignment")
    }
  },
  watch: {
    unificationEntriesListRefreshKey() {
      // TODO: reload data and click in selected row
      // this.datatableObject.ajax.reload();
      setup_entries_for_frames_list({
        table: this.$refs.table,
        lexicalUnitSelected: (lexicalUnitUnifiedFrameId, entryId, lexicalUnitId) => { this.$emit('unifiedFrameSelected', lexicalUnitUnifiedFrameId, entryId, lexicalUnitId); },
        selectEntryId: this.initialEntryId,
        secondarySelectEntryId: this.initialLexicalUnitId
      });
    }
  },
  emits: ['unifiedFrameSelected'],
  mounted () {
    setup_entries_for_frames_list({
      table: this.$refs.table,
      lexicalUnitSelected: (lexicalUnitUnifiedFrameId, entryId, lexicalUnitId) => { this.$emit('unifiedFrameSelected', lexicalUnitUnifiedFrameId, entryId, lexicalUnitId); },
      selectEntryId: this.initialEntryId,
      secondarySelectEntryId: this.initialLexicalUnitId
    });
  },
  template: `
    <table ref="table" class="table table-sm text-dark">
      <thead>
        <tr>
          <th class="p-1">{{ gettext('Lemat') }}</th>
          <th class="p-1">{{ gettext('Część mowy') }}</th>
          <th class="p-1">{{ gettext('Do pobrania') }}</th>
          <th v-if="canViewAssignment" class="p-1">{{ gettext('Semantyk') }}</th>
          <th v-else class="p-1">{{ gettext('Moje (w opracowaniu)') }}</th>
        </tr>
      </thead>
      <tbody id="entries">
      </tbody>
    </table>
  `
};
