import Spinner from './Spinner.js';
import SemanticsSchemataComponent from "./frame-components/SemanticsSchemataComponent.js";
import ExamplesComponent from "./frame-components/ExamplesComponent.js";
import SlowalFrameComponent from "./frame-components/SlowalFrameComponent.js";


export default {
  components: { Spinner, SemanticsSchemataComponent, ExamplesComponent, SlowalFrameComponent },
  props: {
    entryId: Number,
    lexicalUnitId: Number
  },
  data() {
    return {
      frame: null,
      unifiedFrame: undefined,
      gettext: window.gettext,
      hasPermission: window.has_permission,
      subentries: null,
      alternations: null,
      realisation_phrases: null,
      realisation_descriptions: null,
      examples: null,
      selectedFrameArguments: null,
      selectedLus: null,
      selectedSchemas: null
    }
  },
  emits: ['refresh', 'refreshEntriesList'],
  methods: {
    goToEdit (unifiedFrameId, entryId, lexicalUnitId) {
      window.location = `/${lang}/entries/unification?unified_frame_id=${unifiedFrameId}&entry_id=${entryId}&lexical_unit_id=${lexicalUnitId}`;
    },
    hasWhiteSpace(s) {
      return /\s/g.test(s);
    },
    take () {
        const create_title_popup = {
          state0: {
            title: 'Wprowadź nazwę ramy',
            html: '<input type="text" size="32" name="title" />',
            buttons: {Anuluj: 0, Zapisz: 1},
            focus: -1,
            submit: function (e, v, m, f) {
              if (v == 0) {
                $.prompt.close();
              }
              if (v === 1) {
                e.preventDefault();
                const title = f.title;
                if (this.hasWhiteSpace(title) || title.length === 0) {
                  alert(gettext("Nazwa zunifikowanej ramy nie może być pusta oraz nie może zawierać białych znaków."));
                } else {
                  const data = {'lu_id': this.lexicalUnitId, 'unified_frame_title': title};
                  $.ajax({
                    type     : 'post',
                    url      : `/${lang}/unifier/frame_assign/`,
                    dataType : 'json',
                    data: data,
                    timeout  : 60000,
                    success: function (response) {
                      show_info('Rama została stworzona oraz przypisana użytkownikowi.');
                      this.goToEdit(response.unified_frame_id, this.entryId, this.lexicalUnitId);
                    }.bind(this),
                    error: function (request, errorType, errorMessage) {
                      show_error(errorType + ' (' + errorMessage + ')');
                    }
                  });
                }
              }
            }.bind(this)
          }
        }
        $.prompt(create_title_popup);
    },
    statusChange(api_method) {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/${api_method}/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.setup(); this.$emit('refreshEntriesList'); });
    },
    markAsInvalid () {
      this.statusChange('frame_mark_as_invalid');
    },
    markAsBad () {
      this.statusChange('frame_mark_as_bad');
    },
    confirmInvalid () {
      this.statusChange('frame_confirm_invalid');
    },
    frame_confirm_as_not_matching_unified_frame () {
      this.statusChange('frame_confirm_as_not_matching_unified_frame');
    },
    rejectInvalid () {
      this.statusChange('frame_reject_invalid');
    },
    frame_reject_as_not_matching_unified_frame () {
      this.statusChange('frame_reject_as_not_matching_unified_frame');
    },
    isReadyToProcess () {
      return (!this.isLeksykograf() && this.unifiedFrame?.status === 'G') || (this.frame?.status === 'O' && this.unifiedFrame.assignee_username === window.USER_USERNAME);
    },
    isReadyToGet () {
      return this.frame?.status === 'N';
    },
    isLeksykograf () {
      return !has_permission("users.view_assignment");
    },
    setup_notes () {
      setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), this.lexicalUnitId, 'meanings.LexicalUnit', this.setup_notes);
    },
    frameSelectionChanged (selectedFrameArguments, selectedLus) {
      this.selectedLus = selectedLus;
      this.selectedFrameArguments = selectedFrameArguments;
    },
    schemataSelected(schemas) {
      this.selectedSchemas = schemas;
    },
    setup () {
      $('#lexical-unit-notes').html('');

      var data = { 'entry' : this.entryId, 'no_filters' : false, 'lexical_unit_id': this.lexicalUnitId };
      $.ajax({
        type     : 'post',
        url      : '/' + lang + '/entries/get_entry/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {

          window.clear_info();
          this.frame = response.frames[0];
          this.unifiedFrame = response.unified_frame;
          this.subentries = response.subentries;
          this.alternations = response.alternations;
          this.realisation_phrases = response.realisation_phrases;
          this.realisation_descriptions = response.realisation_descriptions;
          this.examples = response.examples;

          window.update_last_visited(response.last_visited);
          window.setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), this.lexicalUnitId, 'meanings.LexicalUnit', this.setup_notes);
        }.bind(this),
        error: function(request, errorType, errorMessage) {
          show_error(errorType + ' (' + errorMessage + ')');
        }
      });
    }
  },
  mounted () {
    Split(['#main-frames-pane', '#vue-examples'], {
      direction: 'vertical',
      sizes: [75, 25],
      gutterSize: 4,
    });
    Split(['#semantics-frames-pane', '#semantics-schemata-pane'], {
      sizes: [40, 60],
      gutterSize: 4,
      elementStyle: (dimension, size, gutterSize) => {
        return {
          'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
        }
      },
    });
    this.setup();
  },
  template: `
    <div class="col p-0 h-100 overflow-hidden">
      <div id="main-frames-pane" class="row">
        <div class="col h-100 pl-3 pr-1 pt-0 pb-2 overflow-auto" id="semantics-frames-pane">
            <spinner />
            <div id="vue-semantics-frames" v-if="frame">
               <slowal-frame-component 
                  :frame="frame" :key="frame"
                  @frame-selection-changed="frameSelectionChanged"
               />
            </div>
      
            <div class="text-center mb-3">
              <div>
                <a class="btn btn-sm btn-outline-dark mr-2" v-if="frame?.status === 'N'" @click="isLeksykograf() ? markAsInvalid() : markAsBad()">{{ !isLeksykograf() ? gettext('Zła') : gettext('Błędna') }}</a>
                <a class="btn btn-sm btn-outline-dark mr-2" v-if="isReadyToGet() && unifiedFrame === null" @click="take">{{ gettext('Pobierz') }}</a>
                <a
                  class="btn btn-sm btn-outline-dark mr-2"
                  v-if="isReadyToProcess()"
                  @click="goToEdit(this.unifiedFrame.pk, this.entryId, this.lexicalUnitId)"
                >
                  {{ this.frame?.status === 'O' ? gettext('Obrabiaj') : gettext('Sprawdź') }}
                </a>
                <a
                  class="btn btn-sm btn-outline-dark mr-2"
                  v-if="frame?.status === 'S' && unifiedFrame?.status === 'S'"
                  @click="goToEdit(this.unifiedFrame.pk)"
                >
                  {{ gettext('Obejrzyj') }}
                </a>
                <a
                  class="btn btn-sm btn-outline-dark mr-2"
                  v-if="(frame?.status === 'B' || frame?.status === 'C') && hasPermission('semantics.manage_invalid_lexical_units')"
                  @click="frame?.status === 'C' ? frame_confirm_as_not_matching_unified_frame() : confirmInvalid()"
                >
                  {{ gettext('Potwierdź') }}
                </a>
                <a
                  class="btn btn-sm btn-outline-dark mr-2"
                  v-if="(frame?.status === 'B' || frame?.status === 'C') && hasPermission('semantics.manage_invalid_lexical_units')"
                  @click="frame?.status === 'C' ? frame_reject_as_not_matching_unified_frame() : rejectInvalid()"
                >
                  {{ gettext('Odrzuć') }}
                </a>
              </div>
            </div>
            <div id="lexical-unit-notes"></div>
          </div>
        <div class="col h-100 px-1 pt-0 pb-0 overflow-auto" id="semantics-schemata-pane">
          <semantics-schemata-component 
            :subentries="subentries"
            :key="subentries"
            :frame="frame"
            :alternations="alternations"
            :realisation_phrases="realisation_phrases"
            :realisation_descriptions="realisation_descriptions"
            @schemata-selected="schemataSelected"
          />
        </div>
      </div>
      <div id="vue-examples" class="row overflow-auto">
        <div class="col w-100 pr-4 overflow-auto">
          <examples-component v-if="examples"
              :examples="examples" 
              :frame="frame"
              :frame_arguments="selectedFrameArguments"
              :lus="selectedLus"
              :schemas="selectedSchemas"
              :key="examples"
          />
        </div>
      </div>
    </div>
  `
}
