export default {
  props: {
    text: String,
    visibleText: String
  },
  data () {
    return {
      iconUrl: window.STATIC_URL + 'common/img/info.svg'
    }
  },
  computed: {
    quotedText () {
      return this.text.replace(/"/g, '&quot;');
    }
  },
  mounted () {
    $(this.$refs.tooltip).tooltip();
  },
  template: `
    <span
      data-toggle="tooltip"
      data-placement="bottom"
      data-html="true"
      :title="quotedText"
      ref="tooltip"
    >
      <img v-if="!visibleText" :src="iconUrl" alt="info" width="14" height="14" />
      <span v-else>{{visibleText}}</span>
    </span>
  `
}
