"use strict";

function get_unified_frame(unified_frame_id, related) {
    check_import_status();
    clear_entry();
    show_entry_spinners();
    //var data = { 'forms' : serialize_forms($('#main-form')), 'entry' : entry_id };
    var data = { 'unified_frame_id' : unified_frame_id, 'no_filters' : related };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/get_unified_frame/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            curr_entry = unified_frame_id;
            curr_no_filters = related;
            clear_info();
            curr_alternations = response.alternations;
            curr_realisation_phrases = response.realisation_phrases;
            curr_realisation_descriptions = response.realisation_descriptions;
            curr_examples = response.examples;
            curr_examples_by_id = Object();
            for (var i in curr_examples) {
                curr_examples_by_id[curr_examples[i].id] = curr_examples[i];
            }
            // show_syntax(response.subentries);
            show_unified_frame(response.unified_frame, response.frames)
            show_unified_frame_lexical_units(response.frames)
            fulfill_slowal_frames_arguments_with_empty_elems(response.unified_frame, response.frames)
            show_semantics_unified_view(response.frames, response.subentries);
            // show_unmatched_examples();

            // tooltips with meaning gloss
            activate_tooltips($('#semantics-frames-pane'));
            update_last_visited(response.last_visited);
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}


function slowal_frames2selecional_preferencies(unified_frame, slowal_frames) {
    var unified_argument_2_selecional_preferencies = {}
    for (var i in unified_frame.slowal_frame_mapping) {
        var slowal_frame_mapping = unified_frame.slowal_frame_mapping[i];
        let slowal_frame = slowal_frames.find(o => o.id === slowal_frame_mapping.slowal_frame_id);
        for (var j in slowal_frame_mapping.slowal_frame_argument_mapping) {
            var slowal_frame_argument_mapping = slowal_frame_mapping.slowal_frame_argument_mapping[j];

            let slowal_frame_argument = slowal_frame.arguments.find(o => o.argument_id === slowal_frame_argument_mapping.slowal_frame_agrument_id);

            let preferenceEntry = unified_argument_2_selecional_preferencies[slowal_frame_argument_mapping.unified_frame_agrument_id];
            if(preferenceEntry == null) {
                preferenceEntry = [];
                unified_argument_2_selecional_preferencies[slowal_frame_argument_mapping.unified_frame_agrument_id] = preferenceEntry
            }
            preferenceEntry.push.apply(preferenceEntry, slowal_frame_argument.preferences)
        }
    }
    return unified_argument_2_selecional_preferencies;
}


function fulfill_slowal_frames_arguments_with_empty_elems(unified_frame, slowal_frames) {
    for (var i in unified_frame.slowal_frame_mapping) {
        var slowal_frame_mapping = unified_frame.slowal_frame_mapping[i];
        let slowal_frame = slowal_frames.find(o => o.id === slowal_frame_mapping.slowal_frame_id);
        let new_slowal_frame_arguments = [];
        for (var j in unified_frame.arguments) {
            var unified_frame_argument = unified_frame.arguments[j];

            let unified_frame_argument_mapping = slowal_frame_mapping.slowal_frame_argument_mapping.find(o => o.unified_frame_agrument_id === unified_frame_argument.id);

            let slowal_frame_argument = null;

            if(unified_frame_argument_mapping == null) {
                slowal_frame_argument = {
                    'str'         : 'Empty',
                    'id'          : slowal_frame.id+'-_'+(unified_frame_argument.id),
                    'role'        : 'Empty',
                    'role_type'   : 'Empty',
                    'preferences' : [],
                    'proposed_roles': [],
                }
            } else {
                slowal_frame_argument = slowal_frame.arguments.find(o => o.argument_id === unified_frame_argument_mapping.slowal_frame_agrument_id);
            }

            new_slowal_frame_arguments.push(slowal_frame_argument)
        }
        slowal_frame.arguments = new_slowal_frame_arguments;
    }
}

function frames2lexical_units(frames) {
    var lexical_units = []
    for (var i in frames) {
        var frame = frames[i];
        for (var j in frame.lexical_units) {
            var lexical_unit = frame.lexical_units[j];
            lexical_unit.opinion = frame.opinion;
            lexical_unit.opinion_key = frame.opinion_key;
            lexical_units.push(lexical_unit);
        }
    }
    return lexical_units;
}
