import LexicalUnitDisplay from './LexicalUnitDisplay.js';
import LexicalUnitEdit from './LexicalUnitEdit.js';

export default {
  components: {LexicalUnitDisplay, LexicalUnitEdit},
  props: {
    entryId: Number,
    lexicalUnitId: Number,
  },
  data () {
    return this.getInitialData();
  },
  methods: {
    getInitialData () {
      return {
        isEdit: false,
        key: this.lexicalUnitId,
        unifiedFrameId: null,
        previewedUnifiedFrameId: null
      };
    },
    goToEdit (unifiedFrameId) {
      this.isEdit = true;
      this.unifiedFrameId = unifiedFrameId;
      this.previewedUnifiedFrameId = -1;
    },
    goToDisplay () {
      this.isEdit = false;
      this.unifiedFrameId = null;
    },
    refresh () {
      this.key = null;
      setTimeout(() => { this.key = this.lexicalUnitId; }, 0);
      update_entries();
    },
    swapFrames (previewedUnifiedFrameId) {
      this.previewedUnifiedFrameId = this.unifiedFrameId;
      this.unifiedFrameId = previewedUnifiedFrameId;
      this.refresh();
    }
  },
  watch: {
    lexicalUnitId () {
      Object.assign(this, this.getInitialData());
    }
  },
  template: `
    <div v-if="key" :key="key" class="row h-100 m-0 p-0 overflow-auto" id="semantics-top-pane">
      <lexical-unit-display
        v-if="lexicalUnitId && !isEdit"
        :entryId="entryId"
        :lexicalUnitId="lexicalUnitId"
        @go-to-edit="goToEdit"
        @refresh="refresh"
      />
      <lexical-unit-edit
        v-if="isEdit"
        :readOnly="false"
        :unifiedFrameId="unifiedFrameId"
        :previewedUnifiedFrameId="previewedUnifiedFrameId"
        :initialRightPaneTab="unifiedFrameId !== previewedUnifiedFrameId ? 'frame_preview' : null"
        @go-to-display="goToDisplay"
        @swap-frames="swapFrames"
      />
    </div>
  `
}
