import Spinner from './Spinner.js';

export default {
  components: { Spinner },
  props: {
    entryId: Number,
    lexicalUnitId: Number
  },
  data() {
    return { frame: null, unifiedFrame: undefined, gettext: window.gettext, hasPermission: window.has_permission }
  },
  emits: ['goToEdit', 'refresh'],
  methods: {
    markAsInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_mark_as_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    take () {
      $.ajax({
        type     : 'post',
        url      : `/${lang}/semantics/frame_assign/${this.frame.id}/`,
        dataType : 'json',
        timeout  : 60000,
      }).then(() => { this.$emit('goToEdit', this.unifiedFrame.pk); });
    },
    confirmInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_confirm_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    rejectInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_reject_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    isReadyToProcess() {
      return this.isLeksykograf() || (this.frame?.status === 'O' || this.frame?.status === 'G') && this.unifiedFrame?.status === 'O';
    },
    isLeksykograf() {
      return !has_permission("users.view_assignment");
    }
  },
  created () {
    $('#lexical-unit-notes').html('');
    get_entry(this.entryId, false, this.lexicalUnitId).then(entry => {
      this.frame = entry.frames[0];
      this.unifiedFrame = entry.unified_frame;
      setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), this.lexicalUnitId, this.entryId);
    });
  },
  mounted () {
    Split(['#semantics-frames-pane', '#semantics-schemata-pane'], {
      sizes: [40, 60],
      minSize: 400,
      gutterSize: 4,
      elementStyle: (dimension, size, gutterSize) => {
        return {
          'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
        }
      },
    });
  },
  template: `
    <div class="col h-100 px-1 pt-0 pb-2 overflow-auto" id="semantics-frames-pane">
      <spinner />
      <div id="semantics-frames"></div>
      <div class="text-center mb-3">
        <div v-if="unifiedFrame">
          <a class="btn btn-sm btn-outline-dark mr-2" v-if="frame?.status === 'N'" @click="markAsInvalid">{{ gettext('Błędna') }}</a>
          <a class="btn btn-sm btn-outline-dark mr-2" v-if="frame?.status === 'N'" @click="take">{{ gettext('Pobierz') }}</a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="isReadyToProcess() || isLeksykograf"
            @click="$emit('goToEdit', this.unifiedFrame.pk)"
          >
            {{ isLeksykograf() ? gettext('Obrabiaj') : gettext('Sprawdź') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'S' && unifiedFrame?.status === 'S'"
            @click="$emit('goToEdit', this.unifiedFrame.pk)"
          >
            {{ gettext('Obejrzyj') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'B' && hasPermission('semantics.manage_invalid_lexical_units')"
            @click="confirmInvalid"
          >
            {{ gettext('Potwierdź') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'B' && hasPermission('semantics.manage_invalid_lexical_units')"
            @click="rejectInvalid"
          >
            {{ gettext('Odrzuć') }}
          </a>
        </div>
        <span v-if="unifiedFrame === null">{{ gettext('Brak ramy unifikacyjnej') }}</span>
      </div>
      <div id="lexical-unit-notes"></div>
    </div>
    <div class="col h-100 px-1 pt-0 pb-0 overflow-auto" id="semantics-schemata-pane">
      <div id="semantics-schemata"></div>
    </div>
  `
}
