from django.utils.text import format_lazy
from django.utils.translation import gettext_lazy as _

def STATUS():
    return {
        'do obróbki'     : _('do obróbki'),
        'w obróbce'      : _('w obróbce'),
        'do usunięcia'   : _('do usunięcia'),
        'gotowe'         : _('gotowe'),
        'zalążkowe'      : _('zalążkowe'),
        'sprawdzone'     : _('sprawdzone'),
        '(F) w obróbce'  : _('(F) w obróbce'),
        '(F) gotowe'     : _('(F) gotowe'),
        '(F) sprawdzone' : _('(F) sprawdzone'),
        '(S) w obróbce'  : _('(S) w obróbce'),
        '(S) gotowe'     : _('(S) gotowe'),
        '(S) sprawdzone' : _('(S) sprawdzone'),
    }

def POS():
    return {
        'adj'  : _('przymiotnik'),
        'adv'  : _('przysłówek'),
        'noun' : _('rzeczownik'),
        'verb' : _('czasownik'),
    }

def ASPECT():
    return {
        'perf' : _('dokonany'),
        'imperf' : _('niedokonany'),
    }

def NEGATION():
    return {
        'neg' : _('zanegowany'),
        'aff' : _('niezanegowany'),
        '_' : _('dowolny'),
    }

TRUE_FALSE_YES_NO = { 'true' : _('tak'), 'false' : _('nie'), }

def SCHEMA_OPINION():
    return  {
        'vul' : _('wulgarny'),
        'col' : _('potoczny'),
        'dat' : _('archaiczny'),
        'bad' : _('zły'),
        'unc' : _('wątpliwy'),
        'cer' : _('pewny'),
    }

def FRAME_OPINION():
    return {
        'vul' : _('wulgarna'),
        'col' : _('potoczna'),
        'dat' : _('archaiczna'),
        'bad' : _('zła'),
        'unc' : _('wątpliwa'),
        'cer' : _('pewna'),
        'rar' : _('sporadyczna'),
        'dom' : _('dziedzinowa'),
        'met' : _('metaforyczna'),
        'unk' : _('nieznana'),
    }

def GRAM_FUNCTION():
    return {
        'subj' : _('podmiot'),
        'obj'  : _('dopełnienie'),
        'head' : _('centrum'),
    }

def CONTROL():
    return {
        'controller' : _('kontrolujący'),
        'controllee' : _('kontrolowany'),
        'controller2' : _('kontrolujący #2'),
        'controllee2' : _('kontrolowany #2'),
        'pred_controller' : _('kontrolujący'),
        'pred_controllee' : _('kontrolowany'),
    }

def PHRASE_ATTRIBUTE():
    return {
        'case'      : _('Przypadek'),
        'num'       : _('Liczba'),
        'gend'      : _('Rodzaj'),
        'deg'       : _('Stopień'),
        'prep'      : _('Przyimek'),
        'comprep'   : _('Przyimek złożony'),
        'inhsie'    : _('Inherentne <i>się</i>'),
        'neg'       : _('Zanegowanie'),
        'cptype'    : _('Typ frazy zdaniowej'),
        'cpreals'   : _('Realizacje'),
        'aspect'    : _('Aspekt'),
        'advcat'    : _('Typ okolicznika'),
        'comparcat' : _('Typ frazy porównawczej'),
        'text'      : _('Postać frazy zleksykalizowanej'),
    }

def PHRASE_ATTRIBUTE_VALUE():
    return {
        'str'   : (_('strukturalny'), _('mianownik na pozycji podmiotu, biernik albo dopełniacz w zależności od negacji na pozycji dopełnienia')),
        'nom'   : _('mianownik'),
        'gen'   : _('dopełniacz'),
        'dat'   : _('celownik'),
        'acc'   : _('biernik'),
        'inst'  : _('narzędnik'),
        'loc'   : _('miejscownik'),
        'pred'  : (_('predykatywny'), _('narzędnik bądź przypadek narzucany przez element kontrolujący na pozycji predykatywnej')),
        'part'  : (_('partytytwny'), _('przypadek służący do opisu rozchwiania pomiędzy biernikiem a dopełniaczem charakterystycznego dla rzeczowników partytywnych (podzielnych, np. <i>chleb</i>) oraz niepoliczalnych (np. <i>woda</i>). Np. <i>zjeść chleb/chleba</i>, <i>nalać wodę/wody</i>)')),
        'postp' : _('poprzyimkowy'),
        'agr'   : _('uzgodnienie'),
        '_'     : _('dowolnie'),
        'sg'    : _('pojedyncza'),
        'pl'    : _('mnoga'),
        'm1'    : _('męski osobowy'),
        'm2'    : _('męski żywotny'),
        'm3'    : _('męski nieżywotny'),
        'f'     : _('żeński'),
        'n'     : _('nijaki'),
        'pos'   : _('równy'),
        'com'   : _('wyższy'),
        'sup'   : _('najwyższy'),
        'locat' : format_lazy('{} {}', _('lokatywna'), _('(miejsce)')),
        'abl'   : format_lazy('{} {}', _('ablatywna'), _('(miejsce początkowe)')),
        'adl'   : format_lazy('{} {}', _('adlatywna'), _('(miejsce końcowe)')),
        'perl'  : format_lazy('{} {}', _('perlatywna'), _('(trasa)')),
        'temp'  : format_lazy('{} {}', _('temporalna'), _('(czasu)')),
        'dur'   : format_lazy('{} {}', _('duratywna'), _('(trwania)')),
        'mod'   : _('sposobu'),
        'caus'  : format_lazy('{} {}', _('kauzatywna'), _('(przyczyny)')),
        'dest'  : format_lazy('{} {}', _('destynacyjna'), _('(celu)')),
        'instr' : format_lazy('{} {}', _('instrumentalna'), _('(narzędzie)')),
    }

def PHRASE_TYPE():
    return {
        'adjp'      : _('przymiotnikowa'),
        'advp'      : _('przysłówkowa'),
        'compar'    : _('porównawcza'),
        'comprepnp' : _('przyimkowa z przyimkiem złożonym'),
        'cp'        : _('zdaniowa'),
        'distrp'    : _('dystrybutywna'),
        # TODO
        'E'         : _('podmiot czasownika wymagającego bezokolicznika'),
        'fixed'     : _('zamrożona fraza zleksykalizowana'),
        'infp'      : _('bezokolicznikowa'),
        'lex'       : _('fraza zleksykalizowana'),
        'ncp'       : _('zdaniowa z korelatem'),
        'nonch'     : _('niechromatyczna'),
        'np'        : _('rzeczownikowa'),
        'nump'      : _('liczebnikowa'),
        'or'        : _('mowa niezależna'),
        'possp'     : _('posesywna'),
        'ppasp'     : _('imiesłowowa'),
        'prepadjp'  : _('przyimkowo-przymiotnikowa'),
        'prepgerp'  : _('przyimkowo-odsłownikowa'),
        'prepncp'   : _('zdaniowa z korelatem przyimkowym'),
        'prepnp'    : _('przyimkowo-rzeczownikowa'),
        'prepnump'  : _('przyimkowo-liczebnikowa'),
        'prepppasp' : _('przyimkowo-imiesłowowa'),
        'qub'       : _('partykuła'),
        'recip'     : _('wzajemnościowa partykuła się'),
        'refl'      : _('zwrotna partykuła się'),
        'xp'        : _('okolicznikowa'),
    }

# phrase types that should not be displayed as “Fraza xyz”, but “Xyz”
NO_PHRASE_NAME = (
    'E', 'fixed', 'lex', 'or', 'qub', 'recip', 'refl',
)

def LEMMA_OPERATOR():
    return {
        'or'  : _('lub'),
        'xor' : _('wyłącznie'),
    }

def LEMMA_COOCCUR():
    return {
        'concat' : _('szeregowo (bez spójnika)'),
        'coord'  : _('koordynacja (ze spójnikiem)'),
    }

def RELATION():
    return {
        'RELAT' : _('RELAT'),
        'fuzzynimia synsetów' : _('fuzzynimia synsetów'),
        'holonimia' : _('holonimia'),
        'holonimia (typu część)' : _('holonimia (typu część)'),
        'holonimia (typu element taksonomiczny)' : _('holonimia (typu element taksonomiczny)'),
        'holonimia (typu element)' : _('holonimia (typu element)'),
        'holonimia (typu materiał)' : _('holonimia (typu materiał)'),
        'holonimia (typu miejsce)' : _('holonimia (typu miejsce)'),
        'holonimia (typu porcja)' : _('holonimia (typu porcja)'),
        'meronimia' : _('meronimia'),
        'meronimia (typu część)' : _('meronimia (typu część)'),
        'meronimia (typu element taksonomiczny)' : _('meronimia (typu element taksonomiczny)'),
        'meronimia (typu element)' : _('meronimia (typu element)'),
        'meronimia (typu materiał)' : _('meronimia (typu materiał)'),
        'meronimia (typu miejsce)' : _('meronimia (typu miejsce)'),
        'meronimia (typu porcja)' : _('meronimia (typu porcja)'),
        'nosiciel stanu/cechy' : _('nosiciel stanu/cechy'),
        'stan/cecha' : _('stan/cecha'),
        'synonimia międzyparadygmatyczna' : _('synonimia międzyparadygmatyczna'),

    }

def EXAMPLE_SOURCE():
    return {
        'NKJP0.5M' : _('Korpus Słownika Frekwencyjnego (0,5M segmentów)'),
        'NKJP1.2M' : _('korpus ręcznie anotowany (1,2M segmentów)'),
        'NKJP30M' : _('próbka Korpusu IPI PAN (2. wydanie; 30M segmentów)'),
        'NKJP250M' : _('pełny Korpus IPI PAN (2. wydanie; 250M segmentów)'),
        'NKJP300M' : _('podkorpus zrównoważony NKJP (300M segmentów)'),
        'NKJP500M' : _('demo NKJP (wersja 2; 500M segmentów)'),
        'NKJP1800M' : _('pełny NKJP (1800M segmentów)'),
        'linguistic_literature' : _('literatura lingwistyczna'),
        'other_literature' : _('literatura inna'),
        'own' : _('własny'),
    }

def EXAMPLE_OPINION():
    return  {
        'zły'      : _('zły'),
        'wątpliwy' : _('wątpliwy'),
        'dobry'    : _('dobry'),
    }
