import UnificationSwitchableList from "./UnificationSwitchableList.js";
import UnificationRightPane from "./UnificationRightPane.js";

export default {
  data () {
    return {
      entryId: null,
      lexicalUnitId: null,
      unifiedFrameId: null,
      isEdit: false,
      gettext: window.gettext,
      unificationEntriesListRefreshKey: 1,
    };
  },
  components: {UnificationSwitchableList, UnificationRightPane},
  methods: {
    lexicalUnitSelected (entryId, lexicalUnitId) {
      this.entryId = entryId;
      this.lexicalUnitId = lexicalUnitId;
      this.isEdit = false;
    },
    unifiedFrameSelected (unifiedFrameId) {
      this.isEdit = true;
      this.unifiedFrameId = unifiedFrameId;
    },
    refreshEntriesList() {
      this.unificationEntriesListRefreshKey++;
    }
  },
  setup() {
    const lexicalUnit = new URL(location.href).searchParams.get('lexical_unit_id');
    const entryId = new URL(location.href).searchParams.get('entry_id');
    return {
      initialLexicalUnitId: parseInt(lexicalUnit),
      initialEntryId: parseInt(entryId),
    };
  },
  mounted () {
    if (window.initialUnifiedFrameId) {
      setTimeout(() => { this.unifiedFrameSelected(window.initialUnifiedFrameId); }, 1000);
    }
    $('#entries-list').length && Split(['#entries-list', '#entry-display'], {
      sizes: [20, 80],
      minSize: 300,
      gutterSize: 4,
      elementStyle: (dimension, size, gutterSize) => {
        return {
          'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
        }
      },
    });
  },
  template: `
    <div id="entries-list" class="col h-100 w-100 px-0">
        <div id="entries-list-div" class="col p-0 h-100 w-100 overflow-auto">
            <unification-switchable-list
              :unificationEntriesListRefreshKey="unificationEntriesListRefreshKey"
              :initialLexicalUnitId="initialLexicalUnitId"
              :initialEntryId="initialEntryId"
              @lexical-unit-selected="lexicalUnitSelected"
              @unified-frame-selected="unifiedFrameSelected"
            />
        </div>
    </div>
    <div id="entry-display" class="col h-100 p-0">
        <unification-right-pane 
          :entryId="entryId" 
          :lexicalUnitId="lexicalUnitId" 
          :initialUnifiedFrameId="unifiedFrameId"
          :initialIsEdit="isEdit"
          @refresh-entries-list="refreshEntriesList"
        />
    </div>
  `
};
