from django.core.mail import send_mail
from django.utils.translation import gettext as _
from django.template import loader

from shellvalier.environment import get_environment


def send_new_user_email(site, user, use_https):
    subject = _('Zaproszenie do %s') % (site.name, )
    body = loader.render_to_string('new_user_email.html', {
        'site_name': site.name,
        'protocol': 'https' if use_https else 'http',
        'domain': site.domain,
        'user': user,
    })
    send_mail(subject, body, from_email=get_environment('EMAIL_FROM', default=None), recipient_list=[user.email])
