from django.conf import settings
from django.contrib.auth.models import Group, Permission, User
from django.contrib.contenttypes.models import ContentType
from django.core.management.base import BaseCommand

from financial_settlement.models import FinStatement
from semantics.models import Frame
from users.models import Assignment, Note


class Command(BaseCommand):
    def handle(self, **options):
        Permission.objects.update_or_create(
            content_type=ContentType.objects.get_for_model(Note),
            codename="view_all_notes",
            defaults={"name": "View all Notes"}
        )
        Permission.objects.update_or_create(
            content_type=ContentType.objects.get_for_model(Frame),
            codename="manage_invalid_lexical_units",
            defaults={"name": "Manage invalid Lexical Units"}
        )
        Permission.objects.update_or_create(
            content_type=ContentType.objects.get_for_model(FinStatement),
            codename="edit_statement",
            defaults={"name": "Edit financial statement"}
        )
        Permission.objects.update_or_create(
            content_type=ContentType.objects.get_for_model(FinStatement),
            codename="add_statement",
            defaults={"name": "Add financial statement"}
        )
        admins, __ = Group.objects.get_or_create(name='Admini')
        admins.permissions.add(
            self._get_permission(User, 'view_user'),
            self._get_permission(User, 'add_user'),
            self._get_permission(User, 'change_user'),
            self._get_permission(User, 'delete_user'),
            self._get_permission(Assignment, 'view_assignment'),
            self._get_permission(Note, 'view_all_notes'),
            self._get_permission(Frame, 'manage_invalid_lexical_units'),
            self._get_permission(FinStatement, 'edit_statement'),
            self._get_permission(FinStatement, 'add_statement'),
        )
        lexicographs, __ = Group.objects.get_or_create(name='Leksykografowie')
        lexicographs.permissions.add(
            # TODO
        )
        super_lexicographs, __ = Group.objects.get_or_create(name=settings.SUPER_LEXICOGRAPHS_GROUP_NAME)
        super_lexicographs.permissions.add(
            self._get_permission(Assignment, 'view_assignment'),
            # self._get_permission(Note, 'view_all_notes'),
            self._get_permission(Frame, 'manage_invalid_lexical_units'),
        )

    def _get_permission(self, model, codename) -> Permission:
        return Permission.objects.get(codename=codename, content_type=ContentType.objects.get_for_model(model))
