#-*- coding:utf-8 -*-

from django.core.management.base import BaseCommand

from meanings.models import LexicalUnit
from semantics.models import SelectivePreference, PredefinedSelectionalPreference

class Command(BaseCommand):
    args = 'none'
    help = ''

    def handle(self, **options):
        #clear_predefined_preferences()
        create_predefined_preferences()
        
def clear_predefined_preferences():
    PredefinedSelectionalPreference.objects.all().delete()
    SelectivePreference.objects.all().delete()

def create_predefined_preferences():
    # ALL
    all, xx = PredefinedSelectionalPreference.objects.get_or_create(name='ALL')
    
    
    # POŁOŻENIE: miejsce-1, przestrzeń-1, obiekt-2
    # OTOCZENIE: człowiek-1, powierzchnia-2, rzecz-4, wytwór-2, pomieszczenie-3
    
    # LUDZIE: osoba-1, grupa ludzi-1
    ludzie_members = SelectivePreference()
    ludzie_members.save()
    osoba_1 = LexicalUnit.objects.get(base='osoba',
                                      sense='1',
                                      pos='noun').synset
    grupa_ludzi_1 = LexicalUnit.objects.get(base='grupa ludzi', 
                                            sense='1',
                                            pos='noun').synset
    ludzie_members.synsets.add(osoba_1)
    ludzie_members.synsets.add(grupa_ludzi_1)
    ludzie_members.save()
    ludzie, xx = PredefinedSelectionalPreference.objects.get_or_create(name='LUDZIE',
                                                                       members=ludzie_members,
                                                                       info='osoba-1, grupa ludzi-1')
    
    # ISTOTY: osoba-1, istota żywa-1, grupa istot-1
    istoty_members = SelectivePreference()
    istoty_members.save()
    # istoty_members.synsets.add(osoba_1)
    istota_zywa_1 = LexicalUnit.objects.get(base='istota żywa', 
                                            sense='1',
                                            pos='noun').synset
    istoty_members.synsets.add(istota_zywa_1)
    grupa_istot_1 = LexicalUnit.objects.get(base='grupa istot', 
                                            sense='1',
                                            pos='noun').synset
    istoty_members.synsets.add(grupa_istot_1)
    istoty_members.save()
    istoty, xx = PredefinedSelectionalPreference.objects.get_or_create(name='ISTOTY',
                                                                       members=istoty_members,
                                                                       info='osoba-1, istota żywa-1, grupa istot-1')
    
    # PODMIOTY: LUDZIE, podmiot-3
    podmioty_members = SelectivePreference()
    podmioty_members.save()
    podmioty_members.generals.add(ludzie)
    podmiot_3 = LexicalUnit.objects.get(base='podmiot', 
                                        sense='3',
                                        pos='noun').synset
    podmioty_members.synsets.add(podmiot_3)
    podmioty_members.save()
    podmioty, xx = PredefinedSelectionalPreference.objects.get_or_create(name='PODMIOTY',
                                                                         members=podmioty_members,
                                                                         info='LUDZIE, podmiot-3')
    
    # DOBRA: jedzenie-2, mienie-1, przedmiot-1, wytwór-1 ==> JADŁO, mienie-1, przedmiot-1, wytwór-1
    dobra_members = SelectivePreference()
    dobra_members.save()
    jedzenie_2 = LexicalUnit.objects.get(base='jedzenie',
                                        sense='2',
                                        pos='noun').synset
    dobra_members.synsets.add(jedzenie_2)
    mienie_1 = LexicalUnit.objects.get(base='mienie', 
                                       sense='1',
                                       pos='noun').synset
    dobra_members.synsets.add(mienie_1)
    przedmiot_1 = LexicalUnit.objects.get(base='przedmiot', 
                                          sense='1',
                                          pos='noun').synset
    dobra_members.synsets.add(przedmiot_1)
    wytwor_1 = LexicalUnit.objects.get(base='wytwór', 
                                       sense='1',
                                       pos='noun').synset
    dobra_members.synsets.add(wytwor_1)
    dobra_members.save()
    dobra, xx = PredefinedSelectionalPreference.objects.get_or_create(name='DOBRA',
                                                                      members=dobra_members,
                                                                      info='JADŁO, mienie-1, przedmiot-1, wytwór-1')
    
    # KOMUNIKAT: informacja-1, wypowiedź-1
    komunikat_members = SelectivePreference()
    komunikat_members.save()
    informacja_1 = LexicalUnit.objects.get(base='informacja',
                                           sense='1',
                                           pos='noun').synset
    komunikat_members.synsets.add(informacja_1)
    wypowiedz_1 = LexicalUnit.objects.get(base='wypowiedź', 
                                          sense='1',
                                          pos='noun').synset
    komunikat_members.synsets.add(wypowiedz_1)
    komunikat_members.save()
    komunikat, xx = PredefinedSelectionalPreference.objects.get_or_create(name='KOMUNIKAT',
                                                                          members=komunikat_members,
                                                                          info='informacja-1, wypowiedź-1')
    
    # KONCEPCJA: informacja-1, wytwór umysłu-1
    koncepcja_members = SelectivePreference()
    koncepcja_members.save()
    koncepcja_members.synsets.add(informacja_1)
    wytwor_umyslu_1 = LexicalUnit.objects.get(base='wytwór umysłu',
                                              sense='1',
                                              pos='noun').synset
    koncepcja_members.synsets.add(wytwor_umyslu_1)
    koncepcja_members.save()
    koncepcja, xx = PredefinedSelectionalPreference.objects.get_or_create(name='KONCEPCJA',
                                                                          members=koncepcja_members,
                                                                          info='informacja-1, wytwór umysłu-1')
    
    # WYTWÓR: przedmiot-1, wytwór-1
    wytwor_members = SelectivePreference()
    wytwor_members.save()
    wytwor_members.synsets.add(przedmiot_1)
    wytwor_members.synsets.add(wytwor_1)
    wytwor_members.save()
    wytwor, xx = PredefinedSelectionalPreference.objects.get_or_create(name='WYTWÓR',
                                                                       members=wytwor_members,
                                                                       info='przedmiot-1, wytwór-1')
    
    # JADŁO: pokarm-1, napój-1
    jadlo_members = SelectivePreference()
    jadlo_members.save()
    pokarm_1 = LexicalUnit.objects.get(base='pokarm',
                                       sense='1',
                                       pos='noun').synset
    jadlo_members.synsets.add(pokarm_1)
    napoj_1 = LexicalUnit.objects.get(base='napój', 
                                      sense='1',
                                      pos='noun').synset
    jadlo_members.synsets.add(napoj_1)
    jadlo_members.save()
    jadlo, xx = PredefinedSelectionalPreference.objects.get_or_create(name='JADŁO',
                                                                      members=jadlo_members,
                                                                      info='pokarm-1, napój-1')

    #miejsce-1, przestrzeń-1, obiekt-2
    polozenie_members = SelectivePreference()
    polozenie_members.save()
    miejsce_1 = LexicalUnit.objects.get(base='miejsce',
                                       sense='1',
                                       pos='noun').synset
    polozenie_members.synsets.add(miejsce_1)
    przestrzeń_1 = LexicalUnit.objects.get(base='przestrzeń',
                                      sense='1',
                                      pos='noun').synset
    polozenie_members.synsets.add(przestrzeń_1)
    obiekt_2 = LexicalUnit.objects.get(base='obiekt',
                                        sense='2',
                                        pos='noun').synset
    polozenie_members.synsets.add(obiekt_2)
    polozenie_members.save()
    polozenie, xx = PredefinedSelectionalPreference.objects.get_or_create(name='POŁOŻENIE',
                                                                          members=polozenie_members,
                                                                          info='miejsce-1, przestrzeń-1, obiekt-2')

    # MIEJSCE: miejsce-1, przestrzeń-1, obiekt-2 ==> lokal-1, budynek-1, rejon-1, obszar-1, państwo-1, jednostka administracyjna-1, woda-4
    miejsce_members = SelectivePreference()
    miejsce_members.save()
    miejsce_1 = LexicalUnit.objects.get(base='miejsce',
                                        sense='1',
                                        pos='noun').synset
    miejsce_members.synsets.add(miejsce_1)
    przestrzen_1 = LexicalUnit.objects.get(base='przestrzeń', 
                                        sense='1',
                                        pos='noun').synset
    miejsce_members.synsets.add(przestrzen_1)
    obiekt_2 = LexicalUnit.objects.get(base='obiekt', 
                                        sense='2',
                                        pos='noun').synset
    miejsce_members.synsets.add(obiekt_2)
    miejsce_members.save()
    miejsce, xx = PredefinedSelectionalPreference.objects.get_or_create(name='MIEJSCE',
                                                                        members=miejsce_members,
                                                                        info='lokal-1, budowla-1, rejon-1, obszar-1, państwo-1, jednostka administracyjna-1, woda-4')

    #powierzchnia-2, rzecz-4, wytwór-2, pomieszczenie-3, osoba-1
    otoczenie_members = SelectivePreference()
    otoczenie_members.save()
    powierzchnia_1 = LexicalUnit.objects.get(base='powierzchnia',
                                        sense='1',
                                        pos='noun').synset
    otoczenie_members.synsets.add(powierzchnia_1)
    rzecz_4 = LexicalUnit.objects.get(base='rzecz',
                                             sense='4',
                                             pos='noun').synset
    otoczenie_members.synsets.add(rzecz_4)
    wytwór_2 = LexicalUnit.objects.get(base='wytwór',
                                             sense='2',
                                             pos='noun').synset
    otoczenie_members.synsets.add(wytwór_2)
    pomieszczenie_3 = LexicalUnit.objects.get(base='pomieszczenie',
                                             sense='3',
                                             pos='noun').synset
    otoczenie_members.synsets.add(pomieszczenie_3)
    osoba_1 = LexicalUnit.objects.get(base='osoba',
                                             sense='1',
                                             pos='noun').synset
    otoczenie_members.synsets.add(osoba_1)
    otoczenie_members.save()
    otoczenie, xx = PredefinedSelectionalPreference.objects.get_or_create(name='OTOCZENIE',
                                                                          members=otoczenie_members,
                                                                          info='powierzchnia-2, rzecz-4, wytwór-2, pomieszczenie-3, osoba-1')

# CZAS: chwila-1, czas-3, czas-8, godzina-3
    czas_members = SelectivePreference()
    czas_members.save()
    chwila_1 = LexicalUnit.objects.get(base='chwila',
                                       sense='1',
                                       pos='noun').synset
    czas_members.synsets.add(chwila_1)
    czas_3 = LexicalUnit.objects.get(base='czas', 
                                     sense='3',
                                     pos='noun').synset
    czas_members.synsets.add(czas_3)
    czas_8 = LexicalUnit.objects.get(base='czas', 
                                     sense='8',
                                     pos='noun').synset
    czas_members.synsets.add(czas_8)
    godzina_3 = LexicalUnit.objects.get(base='godzina', 
                                        sense='3',
                                        pos='noun').synset
    czas_members.synsets.add(godzina_3)
    czas_members.save()
    czas, xx = PredefinedSelectionalPreference.objects.get_or_create(name='CZAS',
                                                                     members=czas_members,
                                                                     info='chwila-1, czas-3, czas-8, godzina-3')
    
    # OBIEKTY: osoba-1, obiekt-2, zbiór-1
    obiekty_members = SelectivePreference()
    obiekty_members.save()
    obiekty_members.synsets.add(osoba_1)
    obiekty_members.synsets.add(obiekt_2)
    zbior_1 = LexicalUnit.objects.get(base='zbiór', 
                                      sense='1',
                                      pos='noun').synset
    obiekty_members.synsets.add(zbior_1)
    obiekty_members.save()
    obiekty, xx = PredefinedSelectionalPreference.objects.get_or_create(name='OBIEKTY',
                                                                        members=obiekty_members,
                                                                        info='osoba-1, obiekt-2, zbiór-1')
    
    # CECHA: cecha-1
    cecha_members = SelectivePreference()
    cecha_members.save()
    cecha_1 = LexicalUnit.objects.get(base='cecha',
                                      sense='1',
                                      pos='noun').synset
    cecha_members.synsets.add(cecha_1)
    cecha_members.save()
    cecha, xx = PredefinedSelectionalPreference.objects.get_or_create(name='CECHA',
                                                                      members=cecha_members,
                                                                      info='cecha-1')
    
    # CZYNNOŚĆ: czynność-1
    czynnosc_members = SelectivePreference()
    czynnosc_members.save()
    czynnosc_1 = LexicalUnit.objects.get(base='czynność',
                                         sense='1',
                                         pos='noun').synset
    czynnosc_members.synsets.add(czynnosc_1)
    czynnosc_members.save()
    czynnosc, xx = PredefinedSelectionalPreference.objects.get_or_create(name='CZYNNOŚĆ',
                                                                         members=czynnosc_members,
                                                                         info='czynność-1, czyn-1')

    #czynność-1, zdarzenie-2, okoliczność-1, ciąg zdarzeń-1, CZASOWNIK-1
    sytuacja_members = SelectivePreference()
    sytuacja_members.save()
    czynnosc_1 = LexicalUnit.objects.get(base='czynność',
                                         sense='1',
                                         pos='noun').synset
    sytuacja_members.synsets.add(czynnosc_1)
    zdarzenie_1 = LexicalUnit.objects.get(base='zdarzenie',
                                         sense='2',
                                         pos='noun').synset
    sytuacja_members.synsets.add(zdarzenie_1)
    okoliczność_1 = LexicalUnit.objects.get(base='okoliczność',
                                         sense='1',
                                         pos='noun').synset
    sytuacja_members.synsets.add(okoliczność_1)
    ciąg_zdarzeń_1 = LexicalUnit.objects.get(base='ciąg zdarzeń',
                                         sense='1',
                                         pos='noun').synset
    sytuacja_members.synsets.add(ciąg_zdarzeń_1)
    # czasownik_1 = LexicalUnit.objects.get(base='CZASOWNIK',
    #                                      sense='1',
    #                                      pos='noun').synset
    # sytuacja_members.synsets.add(czasownik_1)
    sytuacja_members.save()
    # SYTUACJA ==> czynność-1, zdarzenie-2, okoliczność-1, ciąg zdarzeń-1
    sytuacja, xx = PredefinedSelectionalPreference.objects.get_or_create(name='SYTUACJA',
                                                                         members=sytuacja_members,
                                                                         info='czynność-1, zdarzenie-2, okoliczność-1, ciąg zdarzeń-1')
    
    # KIEDY: CZAS, SYTUACJA
    kiedy_members = SelectivePreference()
    kiedy_members.save()
    kiedy_members.generals.add(czas)
    kiedy_members.generals.add(sytuacja)
    kiedy_members.save()
    kiedy, xx = PredefinedSelectionalPreference.objects.get_or_create(name='KIEDY',
                                                                      members=kiedy_members,
                                                                      info='CZAS, SYTUACJA')
    
    # CZEMU: CECHA, SYTUACJA, LUDZIE
    czemu_members = SelectivePreference()
    czemu_members.save()
    czemu_members.generals.add(cecha)
    czemu_members.generals.add(sytuacja)
    czemu_members.generals.add(ludzie)
    czemu_members.save()
    czemu, xx = PredefinedSelectionalPreference.objects.get_or_create(name='CZEMU',
                                                                      members=czemu_members,
                                                                      info='CECHA, SYTUACJA, LUDZIE')
    
    # ILOŚĆ: ilość-1, rozmiar-1, rozmiar-2, jednostka-4, wielkość-6
    ilosc_members = SelectivePreference()
    ilosc_members.save()
    ilosc_1 = LexicalUnit.objects.get(base='ilość',
                                      sense='1',
                                      pos='noun').synset
    ilosc_members.synsets.add(ilosc_1)
    rozmiar_1 = LexicalUnit.objects.get(base='rozmiar', 
                                        sense='1',
                                        pos='noun').synset
    ilosc_members.synsets.add(rozmiar_1)
    rozmiar_2 = LexicalUnit.objects.get(base='rozmiar', 
                                        sense='2',
                                        pos='noun').synset
    ilosc_members.synsets.add(rozmiar_2)
    jednostka_4 = LexicalUnit.objects.get(base='jednostka', 
                                          sense='4',
                                          pos='noun').synset
    ilosc_members.synsets.add(jednostka_4)
    wielkosc_6 = LexicalUnit.objects.get(base='wielkość', 
                                         sense='6',
                                         pos='noun').synset
    ilosc_members.synsets.add(wielkosc_6)
    ilosc_members.save()
    ilosc, xx = PredefinedSelectionalPreference.objects.get_or_create(name='ILOŚĆ',
                                                                      members=ilosc_members,
                                                                      info='ilość-1, rozmiar-1, rozmiar-2, jednostka-4, wielkość-6')
