#! /usr/bin/python
# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand

from semantics.models import SelectivePreferenceRelations

RELATIONS = [(-1, 'RELAT'), (14, 'meronimia'), (15, 'holonimia'), (20, 'meronimia (typu część)'), (21, 'meronimia (typu porcja)'), (22, 'meronimia (typu miejsce)'), (23, 'meronimia (typu element)'), (24, 'meronimia (typu materiał)'), (25, 'holonimia (typu część)'), (26, 'holonimia (typu porcja)'), (27, 'holonimia (typu miejsce)'), (28, 'holonimia (typu element)'), (29, 'holonimia (typu materiał)'), (51, 'nosiciel stanu/cechy'), (52, 'stan/cecha'), (61, 'synonimia międzyparadygmatyczna'), (64, 'meronimia (typu element taksonomiczny)'), (65, 'holonimia (typu element taksonomiczny)'), (108, 'fuzzynimia synsetów')]

#==========================================================#
class Command(BaseCommand):
    args = 'none'
    help = ''

    def handle(self, **options):
        import_relations()
        
def import_relations():
    relations = []
    for pid, name in RELATIONS:
        r = SelectivePreferenceRelations(plwn_id=pid, name=name)
        relations.append(r)
        
    SelectivePreferenceRelations.objects.bulk_create(relations)

