"use strict";

var curr_entry = null;

function show_debug(text) {
    $('#debug').html(text);
}

function clear_debug() {
    $('#debug').empty();
}


function show_status(html) {
    $('#status').find('.card-body').html(html);
    $('#status').show();
}

function show_warning(html) {
    $('#warning').find('.card-body').html(html);
    $('#warning').show();
}

function show_warning_text(text) {
    show_warning('<div class="text-center mb-0"><p>' + text + '</p></div>');
}

function clear_info() {
    $('.info').find('.card-body').empty();
    $('.info').hide();
}

function show_spinner() {
    clear_info();
    // silly cat gifs for development
    /*var rnd = Math.floor(Math.random() * 3) + 1;
    show_status('<div class="text-center mb-1"><p>Siem filtruje!</p><img src="' + window.STATIC_URL + 'common/img/loading' + rnd + '.gif" height=180px></div>');*/
    show_status('<div class="text-center"><div class="spinner-grow text-light" role="status"> <span class="sr-only">Proszę czekać, trwa filtrowanie...</span></div></div>');
}

function show_error() {
    clear_info();
    // silly cat gif for development
    /*show_status('<div class="text-center mb-1"><p>Ajajaj, straszny błąd!</p><img src="' + window.STATIC_URL + 'common/img/error.gif" height="320px"></div>');*/
    show_warning_text('Coś poszło nie tak... :(');
    
}

function hide_form_errors() {
    $('.nav-link').removeClass('bg-warning');
    $('.form-error').remove();
}

function show_form_errors(errors) {
    show_warning_text('Formularz filtrowania zawiera błędy.');
    for (var field in errors) {
        var field_element = $('#id_' + field);
        field_element.after('<p class="bg-warning form-error">' + errors[field] + '</p>');
        var tab_id = field_element.closest('.tab-pane').attr('id');
        $('.nav-link').filter('[href="#' + tab_id + '"]').addClass('bg-warning');
    }
}

function show_schemata(subentries) {
    var html = '';
    for (var i in subentries) {
        var subentry = subentries[i];
        html += '<div class="mb-3"><h5 class="bg-primary text-light p-1 mb-3">' + subentry.str + '</h5>';
        for (var j in subentry.schemata) {
            var schema = subentry.schemata[j];
            html += '<div class="border border-primary px-3 mb-3">';
            html += '<p class="mb-0">[' + schema.id + '] ' + schema.opinion + '</p>';
            html += '<div class="row">';
            for (var k in schema.positions) {
                var position = schema.positions[k]
                html += '<div class="col m-1 p-1">' + position.func + '</div>';
            }
            html += '</div>';
            html += '<div class="row mb-2">';
            for (var k in schema.positions) {
                var position = schema.positions[k]
                html += '<div class="col m-1 p-1 border text-break">';
                for (var l in position.phrases) {
                    var phrase = position.phrases[l];
                    var cls = '';
                    for (var m in phrase.arguments) {
                        cls += ' argument-' + phrase.arguments[m];
                    }
                    html += '<div class="phrase p-1 border' + cls + '" data-phr_id="' + phrase.id + '">' + phrase.str + '</div>';
                }
                html += '</div>';
            }
            html += '</div>';
            html += '</div>';
        }
        html += '</div>';
    }
    if (html != '') {
        $('#schemata').html(html);
    } else {
        $('#schemata').html('<p>(brak schematów)</p>');
    }
    $('.phrase').mouseenter(function () {
        $(this).addClass('bg-info text-dark');
        $('.phrase-' + $(this).data('phr_id')).addClass('bg-success text-dark');
    });
    $('.phrase').mouseleave(function () {
        $(this).removeClass('bg-info text-dark');
        $('.phrase-' + $(this).data('phr_id')).removeClass('bg-success text-dark');
    });
}

function show_frames(frames) {
    var html = '';
    for (var i in frames) {
        var frame = frames[i]
        html += '<div class="border border-primary px-3 mb-3">';
        html += '<p class="mb-0">[' + frame.id + '] ' + frame.opinion + '</p>';
        html += '<div class="row">';
        for (var j in frame.arguments) {
            var argument = frame.arguments[j];
            var cls = '';
            for (var k in argument.phrases) {
                cls += ' phrase-' + argument.phrases[k];
            }
            html += '<div class="argument col m-1 p-1 border' + cls + '" data-arg_id="' + argument.id + '">'
            html += '<p>' + argument.str + '</p>';
            for (var k in argument.preferences) {
                html += '<div class="p-1 border">' + argument.preferences[k] + '</div>';
            }
            html += '</div>';
        }
        html += '</div>';
        html += '</div>';
    }
    if (html != '') {
        $('#frames').html(html);
    } else {
        $('#frames').html('<p>(brak ram)</p>');
    }
    $('.argument').mouseenter(function () {
        $(this).addClass('bg-info text-dark');
        $('.argument-' + $(this).data('arg_id')).addClass('bg-success text-dark');
    });
    $('.argument').mouseleave(function () {
        $(this).removeClass('bg-info text-dark');
        $('.argument-' + $(this).data('arg_id')).removeClass('bg-success text-dark');
    });
}

function get_schemata_and_frames(entry_id) {
    $('#schemata').empty();
    show_spinner();
    // TODO should this really be done like this?
    var data = $('#filters-form').serialize();
    data += '&entry=' + entry_id;
    $.ajax({
        type     : 'get',
        url      : '/filters/get_entry/',
        dataType : 'json',
        data : data,
        timeout  : 60000,
        success  : function(response) {
            show_schemata(response.subentries);
            show_frames(response.frames);
            clear_info();
        },
        error: function(request, errorType, errorMessage) {
            show_error();
            show_debug(errorType + ' (' + errorMessage + ')');
        }
    });
}

function show_entries(entries) {
    var html = '';
    for (var i in entries) {
        html += '<tr data-entry="' + entries[i][0] + '" class="entry"><td class="text-uppercase">' + entries[i][1] + '</td><td>' + entries[i][2] + '</td></tr>'
    }
    if (html != '') {
        $('#entries').html(html);
    } else {
        $('#entries').html('<tr><td>(brak haseł)</td></tr>');
    }
    $('.entry').click(function() {
        curr_entry = $(this).data('entry');
        get_schemata_and_frames(curr_entry);
    });
    curr_entry = null;
    $('.entry').first().click();
    $('#results').show();
}

function clear_results() {
    $('#entries').empty();
    $('#schemata').empty();
    $('#frames').empty();
    $('#results').hide();
}

/*function show_filters() {
    var html = '';
    $('#filters-form').find('.form-group').each(function() {
        var txt = '<span class="text-dark">' + $(this).find('label').first().html() + ':</span>';
        $(this).find('input').each(function() {
            txt += (' ' + $(this).val());
        });
        html += '<span class="text-primary bg-info">' + txt + '</span> ';
    });
    $('#active-filters').html(html);
}*/

$(document).ready(function() {
    
    clear_info();
    clear_results();
    
    $('#filters-form').submit(function(event) {
        var submit = $(this).find('#submit-id-filters-submit');
        submit.prop('disabled', true);
        event.preventDefault();
        clear_results();
        clear_debug();
        show_spinner();
        hide_form_errors();
        $.ajax({
            type     : $(this).attr('method'),
            url      : $(this).attr('action'),
            dataType : 'json',
            data     : $(this).serialize(),
            timeout  : 60000,
            success  : function(response) {
                show_debug(response.debug);
                clear_info();
                if (response.errors) {
                    show_form_errors(response.errors);
                }
                show_entries(response.result);
                submit.prop('disabled', false);
                //show_filters();
            },
            error: function(request, errorType, errorMessage) {
                show_error();
                show_debug(errorType + ' (' + errorMessage + ')');
                submit.prop('disabled', false);
            }
        });
    });
    
    $('#id_filter_schema_').change(function() {
        get_schemata_and_frames(curr_entry);
    });
    
    $('#id_filter_frame_').change(function() {
        get_schemata_and_frames(curr_entry);
    });
    
    $('#filters-form').submit();

});
