jQuery.fn.tagName = function() {
    return this.prop('tagName').toLowerCase();
};

// https://stackoverflow.com/questions/3442394/using-text-to-retrieve-only-text-not-nested-in-child-tags
jQuery.fn.immediateText = function() {
    return this.contents().not(this.children()).text();
};

jQuery.urlParam = function (name) {
    var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.search);
    return (results !== null) ? results[1] || 0 : false;
}

function tooltipped_span(text, tooltip_text, cls) {
    var html = tooltip_text.includes('<') ? ' data-html="true"' : '';
    cls = cls ? ' class="' + cls + '"' : '';
    // https://www.w3schools.com/jsref/jsref_replace.asp /xyz/g to replace ALL occurrences of xyz
    return '<span data-toggle="tooltip" data-placement="bottom"' + cls + html + ' title="' + tooltip_text.replace(/"/g, '&quot;') + '">' + text + '</span>';
}

function tooltipped_info(text) {
    return tooltipped_span('<img src="' + window.STATIC_URL + 'common/img/info.svg" alt="info" width="14" height="14"/>', text);
}

function activate_tooltips(selector) {
    selector.find('[data-toggle="tooltip"]').tooltip();
}

function clear_info() {
    $('#info').empty();
    $('#info').removeClass('bg-success bg-info bg-warning bg-danger bg-dark');
    $('.wait-spinner').remove();
}

function show_debug(text) {
    clear_info();
    $('#info').addClass('bg-info');
    $('#info').html('DEBUG: ' + text);
}

function show_info(text) {
    clear_info();
    $('#info').addClass('bg-dark text-light');
    $('#info').html(text);
}

function show_warning(text) {
    clear_info();
    $('#info').addClass('bg-warning');
    $('#info').html(text);
}

function show_error(text) {
    clear_info();
    $('#info').addClass('bg-danger');
    $('#info').html(text);
}

function show_error_alert(text, insert_after) {
    var alert = '<div class="alert alert-danger alert-dismissible fade show" role="alert">' + text + '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
    insert_after.after(alert);
}

function show_warning_alert(text, insert_after) {
    var alert = '<div class="alert alert-warning alert-dismissible fade show" role="alert">' + text + '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
    insert_after.after(alert);
}

function show_info_alert(text, insert_after) {
    var alert = '<div class="alert alert-info alert-dismissible fade show" role="alert">' + text + '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button></div>';
    insert_after.after(alert);
}

function check_import_status() {
    $.ajax({
        type     : 'get',
        url      : '/' + lang + '/common/get_import_status/',
        dataType : 'json',
        success  : function(response) {
            if (response.status === 'in_progress') {
                $('#import-status').html(gettext('Trwa import danych!'));
            } else {
                $('#import-status').empty();
            }
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}
