import json

from django.test import Client
from django.test import RequestFactory, TestCase

# initialize the APIClient app
from connections.models import Entry, POS, Status, ExampleConnection
from examples.models import Example, ExampleOpinion, ExampleSource
from freelus.views import create_new_slowal_frame, add_argument_to_frame, attach_examples_to_frame
from meanings.models import LexicalUnit, Synset
from semantics.models import FrameOpinion, Frame, SemanticRole, ArgumentRole

client = Client()


class ApiTest(TestCase):

    def tearDown(self) -> None:
        pass

    @classmethod
    def tearDownClass(cls):
        pass

    def setUp(self):
        self.factory = RequestFactory()
        FrameOpinion.objects.create(key='unk', priority=1)
        self.synset = Synset.objects.create(id=1, definition='definition')
        self.lu = LexicalUnit.objects.create(base='test', sense=1, pos='A', synset=self.synset)
        pos = POS.objects.create(tag='test_tag')
        status = Status.objects.create(key='status_key', priority=1)
        self.entry = Entry.objects.create(name='test', status=status, pos=pos)
        self.semantic_role = SemanticRole.objects.create(role='test_role', priority=1)
        self.argument_role = ArgumentRole.objects.create(role=self.semantic_role)
        example_opinion = ExampleOpinion.objects.create(key='key', priority=1)
        example_source = ExampleSource.objects.create(key='key', priority=1)
        self.example = Example.objects.create(entry=self.entry, sentence='test sentence', opinion=example_opinion, source=example_source)

    def test_create_new_slowal_frame(self):
        request = self.factory.post("/pl/freelus/create_new_slowal_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'entry_id': self.entry.pk,
                                          'lu_ids': json.dumps([self.lu.pk], separators=(',', ':'))})
        response = create_new_slowal_frame(request)
        self.assertEqual(1, Frame.objects.all().count())
        frame = Frame.objects.all()[0]
        self.assertEqual(0, len(frame.arguments.all()))

    def test_add_argument_to_frame(self):

        request = self.factory.post("/pl/freelus/create_new_slowal_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'entry_id': self.entry.pk,
                                          'lu_ids': json.dumps([self.lu.pk], separators=(',', ':'))})
        response = create_new_slowal_frame(request)

        frame = Frame.objects.all()[0]
        request = self.factory.post("/pl/freelus/add_argument_to_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'frame_id': frame.pk,
                                          'role_id': self.argument_role.pk,
                                          'role_type': 1})
        response = add_argument_to_frame(request)
        frame = Frame.objects.all()[0]
        self.assertEqual(1, len(frame.arguments.all()))

    def test_attach_examples_to_frame(self):

        request = self.factory.post("/pl/freelus/create_new_slowal_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'entry_id': self.entry.pk,
                                          'lu_ids': json.dumps([self.lu.pk], separators=(',', ':'))})
        response = create_new_slowal_frame(request)

        frame = Frame.objects.all()[0]
        request = self.factory.post("/pl/freelus/add_argument_to_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'frame_id': frame.pk,
                                          'role_id': self.argument_role.pk,
                                          'role_type': 1})
        response = add_argument_to_frame(request)
        argument = frame.arguments.all()[0]

        request = self.factory.post("/pl/freelus/attach_examples_to_frame/",
                                    HTTP_X_REQUESTED_WITH='XMLHttpRequest',
                                    data={'frame_id': frame.pk,
                                          'selected_lus': json.dumps([self.lu.pk], separators=(',', ':')),
                                          'example_ids': json.dumps([self.example.pk], separators=(',', ':'))})
        response = attach_examples_to_frame(request)

        examples = ExampleConnection.objects.filter(lexical_unit=self.lu)
        self.assertEqual(1, examples.count())
