function setup_frames_list(options) {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (data) {
        return (
            data
            && data.assignee_username === window.USER_USERNAME
        ) ? gettext("tak") : gettext("nie");
    }

    const ajaxURL = can_see_assignees ? '/' + lang + '/unifier/get_unified_frames/' : '/' + lang + '/unifier/get_unified_frames/?exclude_status=N&restrict_to_user='+window.USER_USERNAME;

    var datatable = setup_datatable({
        element: options.table,
        url: ajaxURL,
        columns: [
            { data: 'title' },
            { data: 'status' },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
            { data: 'id' },
        ],
        hidden_columns: can_see_assignees ? [3] : [2,3]
    });
    datatable.on('click', 'tr.entry', function () {
        var data = datatable.row(this).data();
        if (!data) return;
        var related = data.related === true;
        $('.entry', options.table).removeClass('table-primary');
        options.unifiedFrameSelected(Number(data.id));
        $(this).addClass('table-primary');
    });
}
