from django.utils.text import format_lazy
from django.utils.translation import gettext_lazy as _
from django.utils.translation import pgettext_lazy

from django.utils import translation

def POSITION_PROP():
    return{
        'subj'            : _('podmiot'),
        'obj'             : _('dopełnienie dopuszczające stronę bierną'),
        'head'            : _('rzeczownikowy nadrzędnik składniowy frazy przymiotnikowej'),
        'controller'      : _('pozycja kontrolująca podmiot bezokolicznika lub jego odpowiednik (podnoszenie wykonawcy czynności)'),
        'controllee'      : _('pozycja podlegająca kontroli czynnościowej (dziedzicząca wykonawcę czynności)'),
        'pred_controller' : _('pozycja kontrolująca pozycję predykatywną (posiadacz własności)'),
        'pred_controllee' : _('pozycja predykatywna kontrolowana przez inną pozycję'),
    }

# there’s an NP class in the importer

def NP_():
    # Translators: fraza, rzeczownikowa
    return (_('%(a1)s %(a2)s w {case}'), 'fraza', 'rzeczownikowa')

def NUMP():
    # Translators: fraza, liczebnikowa
    return (_('%(a1)s %(a2)s w {case}'), 'fraza', 'liczebnikowa')

def ADJP():
    # Translators: fraza, przymiotnikowa
    return (_('%(a1)s %(a2)s w {case}'), 'fraza', 'przymiotnikowa')

# TODO różne opisy?
def PPASP():
    # Translators: fraza, imiesłowowa
    return (_('%(a1)s %(a2)s w {case}'), 'fraza', 'imiesłowowa')
def PACTP():
    # Translators: fraza, imiesłowowa
    return (_('%(a1)s %(a2)s w {case}'), 'fraza', 'imiesłowowa')

def CASE_FOR_NP():
    return {
        'nom'  : _('mianowniku'),
        'gen'  : _('dopełniaczu'),
        'dat'  : _('celowniku'),
        'acc'  : _('bierniku'),
        'inst' : _('narzędniku'),
        'str_subj'  : _('przypadku strukturalnym (mianownik)'),
        'str'  : _('przypadku strukturalnym (biernik albo dopełniacz w zależności od negacji)'),
        'pred' : _('przypadku predykatywnym (narzędnik bądź przypadek narzucany przez element kontrolujący na pozycji predykatywnej)'),
        'agr'  : _('przypadku uzgodnionym (z nadrzędnikiem rzeczownikowym w wypadku apozycji lub podrzędnikiem przymiotnikowym)'),
        'part' : _('przypadku służącym do opisu rozchwiania pomiędzy biernikiem a dopełniaczem charakterystycznego dla rzeczowników partytywnych (podzielnych, np. <i>chleb</i>) oraz niepoliczalnych (np. <i>woda</i>). Np. <i>zjeść chleb/chleba</i>, <i>nalać wodę/wody</i>'),
    }

def CASE_FOR_ADJP():
    ret = CASE_FOR_NP()
    ret['agr'] = _('przypadku uzgodnionym z nadrzędnikiem rzeczownikowym')
    return ret

def PREPNP():
    # Translators: fraza, rzeczownikowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>{prep}</i> wymagającym {case}'), 'fraza', 'rzeczownikowa')

def PREPGERP():
    # Translators: fraza, odsłownikowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>{prep}</i> wymagającym {case}'), 'fraza', 'odsłownikowa')

def PREPNUMP():
    # Translators: fraza, liczebnikowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>{prep}</i> wymagającym {case}'), 'fraza', 'liczebnikowa')

def PREPADJP():
    # Translators: fraza, przymiotnikowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>{prep}</i> wymagającym {case}'), 'fraza', 'przymiotnikowa')

def PREPPPASP():
    # Translators: fraza, imiesłowowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>{prep}</i> wymagającym {case}'), 'fraza', 'imiesłowowa')

# TODO dowolna przyimkowa czy przyim-rzecz?
def COMPREPNP():
    # Translators: fraza, rzeczownikowa
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem złożonym <i>{prep}</i>'), 'fraza', 'rzeczownikowa')

def CASE_FOR_PREPNP():
    return {
        'nom'   : _('mianownika'),
        'gen'   : _('dopełniacza'),
        'dat'   : _('celownika'),
        'acc'   : _('biernika'),
        'inst'  : _('narzędnika'),
        'loc'   : _('miejscownika'),
        # TODO przeredagowałam: Przypadek strukturalny występuje tez z przyimkami jak (prepnp(jak, str)) oraz jako (prepnp(jako,str)) będącymi rodzajem konstrukcji porównawczych. Frazy takie występują zawsze na pozycji predykatywnej podlegającej kontroli i uzgadniają przypadek strukturalny z frazą kontrolującą.
        'str'   : _('przypadka strukturalnego występującego z przyimkami <i>jak</i> oraz <i>jako</i> będącymi rodzajem konstrukcji porównawczych (frazy takie występują zawsze na pozycji predykatywnej podlegającej kontroli i uzgadniają przypadek strukturalny z frazą kontrolującą)'),
        # TODO nie było w dokumentacji, występuje np. w prepadjp(po,postp)
        'postp' : _('celownika poprzyimkowego'),
    }


def INFP():
    # Translators: fraza, bezokolicznikowa
    return (_('%(a1)s %(a2)s {aspect}'), 'fraza', 'bezokolicznikowa')

def ASPECT():
    return {
        'imperf' : (_('%(a1)s'), 'niedokonana'),
        'perf'   : (_('%(a1)s'), 'dokonana'),
        '_'      : (_('o dowolnym aspekcie'),)
    }

# there’s a CP class in the importer
# TODO variants for realisations/lexes (no “odpowiedni zaimek...”)
def CP_():
    # Translators: fraza, zdaniowa
    return (_('%(a1)s %(a2)s {typ}'), 'fraza', 'zdaniowa')

def CP_TYPE():
    return {
        # Translators: wprowadzana
        'gdy'   : (_('%(a1)s przez spójnik podrzędny <i>gdy</i> oraz <i>gdyby</i> w trybie przypuszczającym'), 'wprowadzana'),
        # Translators: wprowadzana
        'żeby2' : (_('%(a1)s przez spójnik podrzędny <i>że</i> oraz dodatkowo <i>żeby</i> w konstrukcjach zanegowanych'), 'wprowadzana'),
        # Translators: zależna, wprowadzana
        'int'   : (_('pytajno%(a1)s %(a2)s przez odpowiedni element pytajny'), 'zależna', 'wprowadzana'),
        'rel'   : (_('%(a1)s'), 'względna'),
        # Translators: zależna, wprowadzana
        'int_r' : (_('pytajno%(a1)s %(a2)s przez <i>{conj}</i>'), 'zależna', 'wprowadzana'),
        # Translators: względna, wprowadzana
        'rel_r' : (_('%(a1)s %(a2)s przez <i>{conj}</i>'), 'względna', 'wprowadzana'),
    }

# TODO(?) this is a catch-all, should we check that the conj is valid?
def CP_CONJ():
    # Translators: wprowadzana
    return (_('%(a1)s przez spójnik podrzędny <i>{conj}</i>'), 'wprowadzana')

# there’s an NCP class in the importer
def NCP_():
    # Translators: fraza, zdaniowa
    return (_('%(a1)s %(a2)s {typ}'), 'fraza', 'zdaniowa')

TO = {
    'nom'  : 'to',
    'gen'  : 'tego',
    'dat'  : 'temu',
    'acc'  : 'to',
    'inst' : 'tym',
    'loc'  : 'tym',
    'str'  : 'to',
    'pred' : 'tym',
    'agr'  : 'to',
    'part' : 'tego',
}

def NCP_TYPE():
    return {
        # Translators: wprowadzana
        'gdy'   : (_('%(a1)s przez <i>{to}, gdy</i> bądź <i>{to}, gdyby</i> w trybie przypuszczającym'), 'wprowadzana'),
        # Translators: wprowadzana
        'żeby2' : (_('%(a1)s przez <i>{to}, że</i> bądź dodatkowo <i>{to}, żeby</i> w konstrukcjach zanegowanych'), 'wprowadzana'),
        # Translators: zależna, wprowadzana
        'int'   : (_('pytajno%(a1)s %(a2)s przez <i>{to}, co/czy/ile/kto/…</i> lub dowolny inny element pytajny'), 'zależna', 'wprowadzana'),
        # Translators: względna, wprowadzana
        'rel'   : (_('%(a1)s %(a2)s przez <i>{to}, co/gdzie/kto/…</i>'), 'względna', 'wprowadzana'),
        # Translators: zależna, wprowadzana
        'int_r' : (_('pytajno%(a1)s %(a2)s przez <i>{to}, {conj}</i>'), 'zależna', 'wprowadzana'),
        # Translators: względna, wprowadzana
        'rel_r' : (_('%(a1)s %(a2)s przez <i>{to}, {conj}</i>'), 'względna', 'wprowadzana'),
    }

def NCP_CONJ():
    # Translators: wprowadzana
    return (_('%(a1)s przez <i>{to}, {conj}</i>'), 'wprowadzana')

def PREPNCP_TYPE():
    return {
        # Translators: wprowadzana
        'gdy'   : (_('%(a1)s przez <i>{prep} {to}, gdy</i> bądź <i>{prep} {to}, gdyby</i> w trybie przypuszczającym'), 'wprowadzana'),
        # Translators: wprowadzana
        'żeby2' : (_('%(a1)s przez <i>{prep} {to}, że</i> bądź dodatkowo <i>{prep} {to}, żeby</i> w konstrukcjach zanegowanych'), 'wprowadzana'),
        # Translators: zależna, wprowadzana
        'int'   : (_('pytajno%(a1)s %(a2)s przez <i>{prep} {to}, co/czy/ile/kto/…</i> lub dowolny inny element pytajny'), 'zależna', 'wprowadzana'),
        # Translators: względna, wprowadzana
        'rel'   : (_('%(a1)s %(a2)s przez <i>{prep} {to}, co/gdzie/kto/…</i>'), 'względna', 'wprowadzana'),
        # Translators: zależna, wprowadzana
        'int_r' : (_('pytajno%(a1)s %(a2)s przez <i>{prep} {to}, {conj}</i>'), 'zależna', 'wprowadzana'),
        # Translators: względna, wprowadzana
        'rel_r' : (_('%(a1)s %(a2)s przez <i>{prep} {to}, {conj}</i>'), 'względna', 'wprowadzana'),
    }

def PREPNCP_CONJ():
    # Translators: wprowadzana
    return (_('%(a1)s przez <i>{prep} {to}, {conj}</i>'), 'wprowadzana')

#### advp:
# fraza_1 przysłówkowa_2 lokatywna_3 (miejsce)
# locative_3 adverbial_2 phrase_1 (place)
def ADVP():
    s = pgettext_lazy('fraza przysłówkowa lokatywna/ablatywna/...', '%(a1)s %(a2)s %(a3)s')
    return {
        'locat' : (format_lazy('{} {}', s, _('(miejsce)')), 'fraza', 'przysłówkowa', 'lokatywna'),
        'abl'   : (format_lazy('{} {}', s, _('(miejsce początkowe)')), 'fraza', 'przysłówkowa', 'ablatywna'),
        'adl'   : (format_lazy('{} {}', s, _('(miejsce końcowe)')), 'fraza', 'przysłówkowa', 'adlatywna'),
        'perl'  : (format_lazy('{} {}', s, _('(trasa)')), 'fraza', 'przysłówkowa', 'perlatywna'),
        'temp'  : (format_lazy('{} {}', s, _('(czasu)')), 'fraza', 'przysłówkowa', 'temporalna'),
        'dur'   : (format_lazy('{} {}', s, _('(trwania)')), 'fraza', 'przysłówkowa', 'duratywna'),
        'mod'   : (pgettext_lazy('fraza przysłówkowa', '%(a1)s %(a2)s sposobu'), 'fraza', 'przysłówkowa'),
        'caus'  : (format_lazy('{} {}', s, _('(przyczyny)')), 'fraza', 'przysłówkowa', 'kauzatywna'),
        'dest'  : (format_lazy('{} {}', s,  _('(celu)')), 'fraza', 'przysłówkowa', 'destynacyjna'),
        'instr' : (format_lazy('{} {}', s, _('(narzędzie)')), 'fraza', 'przysłówkowa', 'instrumentalna'),
    }

#### xp without realisations:
# dowolna_1 fraza_2 lokatywna_3 (miejsce)
# any_1 locative_3 phrase_2 (place)
#### xp with realisations:
# fraza_1 lokatywna_2 (miejsce)
# locative_2 phrase_1 (place)
#def XP_SEM():
def XP_(reals):
    if reals:
        # Translators: fraza, lokatywna/ablatywna/...
        s = _('%(a1)s %(a2)s')
        return {
            'locat' : (format_lazy('{} {}', s, _('(miejsce)')), 'fraza', 'lokatywna'),
            'abl'   : (format_lazy('{} {}', s, _('(miejsce początkowe)')), 'fraza', 'ablatywna'),
            'adl'   : (format_lazy('{} {}', s, _('(miejsce końcowe)')), 'fraza', 'adlatywna'),
            'perl'  : (format_lazy('{} {}', s, _('(trasa)')), 'fraza', 'perlatywna'),
            'temp'  : (format_lazy('{} {}', s, _('(czasu)')), 'fraza', 'temporalna'),
            'dur'   : (format_lazy('{} {}', s, _('(trwania)')), 'fraza', 'duratywna'),
            # Translators: fraza
            'mod'   : (_('%(a1)s sposobu'), 'fraza'),
            'caus'  : (format_lazy('{} {}', s, _('(przyczyny)')), 'fraza', 'kauzatywna'),
            'dest'  : (format_lazy('{} {}', s,  _('(celu)')), 'fraza', 'destynacyjna'),
            'instr' : (format_lazy('{} {}', s, _('(narzędzie)')), 'fraza', 'instrumentalna'),
        }
    else:
        s = pgettext_lazy('dowolna fraza lokatywna/ablatywna/...', '%(a1)s %(a2)s %(a3)s')
        return {
            'locat' : (format_lazy('{} {}', s, _('(miejsce)')), 'dowolna', 'fraza', 'lokatywna'),
            'abl'   : (format_lazy('{} {}', s, _('(miejsce początkowe)')), 'dowolna', 'fraza', 'ablatywna'),
            'adl'   : (format_lazy('{} {}', s, _('(miejsce końcowe)')), 'dowolna', 'fraza', 'adlatywna'),
            'perl'  : (format_lazy('{} {}', s, _('(trasa)')), 'dowolna', 'fraza', 'perlatywna'),
            'temp'  : (format_lazy('{} {}', s, _('(czasu)')), 'dowolna', 'fraza', 'temporalna'),
            'dur'   : (format_lazy('{} {}', s, _('(trwania)')), 'dowolna', 'fraza', 'duratywna'),
            'mod'   : (pgettext_lazy('dowolna fraza', '%(a1)s %(a2)s sposobu'), 'dowolna', 'fraza'),
            'caus'  : (format_lazy('{} {}', s, _('(przyczyny)')), 'dowolna', 'fraza', 'kauzatywna'),
            'dest'  : (format_lazy('{} {}', s, _('(celu)')), 'dowolna', 'fraza', 'destynacyjna'),
            'instr' : (format_lazy('{} {}', s, _('(narzędzie)')), 'dowolna', 'fraza', 'instrumentalna'),
        }

def ADVP_PRON():
    # Translators: przysłówki
    return (_('wyłącznie %(a1)s <i>jak</i>, <i>tak</i>'), 'przysłówki')

def ADVP_MISC():
    # Translators: fraza, przysłówkowa, fraza, konstrukcje, przysłówkowe
    return (_('%(a1)s %(a2)s (%(a3)s z centrum przysłówkowym oraz %(a4)s przyimkowo-%(a5)s typu <i>na pewno</i>, <i>bez mała</i>)'), 'fraza', 'przysłówkowa', 'fraza', 'konstrukcje', 'przysłówkowe')

def COMPAR():
    # Translators: fraza, porównawcza, wprowadzana
    return (_('%(a1)s %(a2)s %(a3)s przez <i>{prep}</i>'), 'fraza', 'porównawcza', 'wprowadzana')

def NONCH():
    # Translators: fraza, niechromatyczna, specyficzna, fraza, realizowana
    return (_('%(a1)s %(a2)s, czyli %(a3)s %(a4)s rzeczownikowa w przypadku strukturalnym, %(a5)s wyłącznie przez zaimki <i>co</i>, <i>coś</i>, <i>nic</i>, <i>to</i> oraz nieokreślone frazy liczebnikowe (<i>dużo</i>, <i>niewiele</i> itp.) bez podrzędnika rzeczownikowego'), 'fraza', 'niechromatyczna', 'specyficzna', 'fraza', 'realizowana')

# there’s an OR class in the importer
def OR_():
    # Translators: mowa, niezależna
    return (_('%(a1)s %(a2)s'), 'mowa', 'niezależna')

def REFL():
    # Translators: partykuła, realizująca
    return (_('%(a1)s <i>się</i> %(a2)s użycie zwrotne czasownika (<i>sam siebie</i>)'), 'partykuła', 'realizująca')

def RECIP():
    # Translators: partykuła, realizująca
    return (_('%(a1)s <i>się</i> %(a2)s użycie wzajemnościowe czasownika (<i>siebie nawzajem</i>)'), 'partykuła', 'realizująca')

# there’s an E class in the importer
def E_():
    # Translators: subject
    return (_('%(a1)s czasownika wymagającego bezokolicznika, którego własności są tożsame z narzucanymi przez czasownik w bezokoliczniku, w tym brak podmiotu'), 'podmiot')

def POSSP():
    # Translators: fraza, posesywna, odpowiadająca
    return (_('%(a1)s %(a2)s %(a3)s na pytanie <i>czyj?</i>, np. <i>mój</i>, <i>pański</i>, <i>Anny</i>'), 'fraza', 'posesywna', 'odpowiadająca')

# TODO przeredagowałam: fraza przyimkowo-nominalna z przyimkiem po stosowana w konstrukcjach dystrybutywnych. Charakteryzuje się tym, że typowo przyimek po wymaga miejscownika (prepnp(po,loc) – dać każdemu po jabłku), jednak w wypadku fraz liczebnikowych występuje tam biernik (prepnp(po,acc) – dać każdemu po dwa jabłka).
def DISTRP():
    # Translators: fraza, rzeczownikowa, stosowana
    return (_('%(a1)s przyimkowo-%(a2)s z przyimkiem <i>po</i> %(a3)s w konstrukcjach dystrybutywnych; typowo przyimek <i>po</i> wymaga miejscownika (<i>dać każdemu po jabłku</i>), jednak w wypadku fraz liczebnikowych występuje biernik (<i>dać każdemu po dwa jabłka</i>)'), 'fraza', 'rzeczownikowa', 'stosowana')

def QUB():
    return (_('%(a1)s'), 'partykuła')

XP_SEM_PHRASEO = {
    'locat' : '‹gdzieś›',
    'abl'   : '‹skądś›',
    'adl'   : '‹dokądś›',
    'perl'  : '‹którędyś›',
    'temp'  : '‹kiedyś›',
    'dur'   : '‹przez jakiś czas›',
    'mod'   : '‹w jakiś sposób›',
    'caus'  : '‹z jakiegoś powodu›',
    'dest'  : '‹w jakimś celu›',
    'instr' : '‹za pomocą czegoś›',
    # TODO for advp
    'misc'  : 'TODO',
}

def INFLECTED():
    return {
        'ablatywna'        : { 'nom' : _('ablatywna'),        'gen' : _('ablatywnej'),        'inst' : _('ablatywną') },
        'adlatywna'        : { 'nom' : _('adlatywna'),        'gen' : _('adlatywnej'),        'inst' : _('adlatywną') },
        'bezokolicznikowa' : { 'nom' : _('bezokolicznikowa'), 'gen' : _('bezokolicznikowej'), 'inst' : _('bezokolicznikową') },
        'destynacyjna'     : { 'nom' : _('destynacyjna'),     'gen' : _('destynacyjnej'),     'inst' : _('destynacyjną') },
        'dokonana'         : { 'nom' : _('dokonana'),         'gen' : _('dokonanej'),         'inst' : _('dokonaną') },
        'dowolna'          : { 'nom' : _('dowolna'),          'gen' : _('dowolnej'),          'inst' : _('dowolną') },
        'duratywna'        : { 'nom' : _('duratywna'),        'gen' : _('duratywnej'),        'inst' : _('duratywną') },
        'fraza'            : { 'nom' : _('fraza'),            'gen' : _('frazy'),             'inst' : _('frazą') },
        'instrumentalna'   : { 'nom' : _('instrumentalna'),   'gen' : _('instrumentalnej'),   'inst' : _('instrumentalną') },
        'imiesłowowa'      : { 'nom' : _('imiesłowowa'),      'gen' : _('imiesłowowej'),      'inst' : _('imiesłowową') },
        'kauzatywna'       : { 'nom' : _('kauzatywna'),       'gen' : _('kauzatywnej'),       'inst' : _('kauzatywną') },
        'konstrukcje'      : { 'nom' : _('konstrukcje'),      'gen' : _('konstrukcyj'),       'inst' : _('konstrukcjami') },
        'liczebnikowa'     : { 'nom' : _('liczebnikowa'),     'gen' : _('liczebnikowej'),     'inst' : _('liczebnikową') },
        'lokatywna'        : { 'nom' : _('lokatywna'),        'gen' : _('lokatywnej'),        'inst' : _('lokatywną') },
        'mowa'             : { 'nom' : _('mowa'),             'gen' : _('mowy'),              'inst' : _('mową') },
        'niechromatyczna'  : { 'nom' : _('niechromatyczna'),  'gen' : _('niechromatycznej'),  'inst' : _('niechromatyczną') },
        'niedokonana'      : { 'nom' : _('niedokonana'),      'gen' : _('niedokonanej'),      'inst' : _('niedokonaną') },
        'niezależna'       : { 'nom' : _('niezależna'),       'gen' : _('niezależnej'),       'inst' : _('niezależną') },
        'odpowiadająca'    : { 'nom' : _('odpowiadająca'),    'gen' : _('odpowiadającej'),    'inst' : _('odpowiadającą') },
        'odsłownikowa'     : { 'nom' : _('odsłownikowa'),     'gen' : _('odsłownikowej'),     'inst' : _('odsłownikową') },
        'partykuła'        : { 'nom' : _('partykuła'),        'gen' : _('partykuły'),         'inst' : _('partykułą') },
        'perlatywna'       : { 'nom' : _('perlatywna'),       'gen' : _('perlatywnej'),       'inst' : _('perlatywną') },
        'podmiot'          : { 'nom' : _('podmiot'),          'gen' : _('podmiotu'),          'inst' : _('podmiotem') },
        'posesywna'        : { 'nom' : _('posesywna'),        'gen' : _('posesywnej'),        'inst' : _('posesywną') },
        'porównawcza'      : { 'nom' : _('porównawcza'),      'gen' : _('porównawczej'),      'inst' : _('porównawczą') },
        'przymiotnikowa'   : { 'nom' : _('przymiotnikowa'),   'gen' : _('przymiotnikowej'),   'inst' : _('przymiotnikową') },
        'przysłówki'       : { 'nom' : _('przysłówki'),       'gen' : _('przysłówków'),       'inst' : _('przysłówkami') },
        'przysłówkowa'     : { 'nom' : _('przysłówkowa'),     'gen' : _('przysłówkowej'),     'inst' : _('przysłówkową') },
        'przysłówkowe'     : { 'nom' : _('przysłówkowe'),     'gen' : _('przysłówkowych'),    'inst' : _('przysłówkowymi') },
        'realizowana'      : { 'nom' : _('realizowana'),      'gen' : _('realizowanej'),      'inst' : _('realizowaną') },
        'realizująca'      : { 'nom' : _('realizująca'),      'gen' : _('realizującej'),      'inst' : _('realizującą') },
        'rzeczownikowa'    : { 'nom' : _('rzeczownikowa'),    'gen' : _('rzeczownikowej'),    'inst' : _('rzeczownikową') },
        'specyficzna'      : { 'nom' : _('specyficzna'),      'gen' : _('specyficznej'),      'inst' : _('specyficzną') },
        'stosowana'        : { 'nom' : _('stosowana'),        'gen' : _('stosowanej'),        'inst' : _('stosowaną') },
        'temporalna'       : { 'nom' : _('temporalna'),       'gen' : _('temporalnej'),       'inst' : _('temporalną') },
        'wprowadzana'      : { 'nom' : _('wprowadzana'),      'gen' : _('wprowadzanej'),      'inst' : _('wprowadzaną') },
        'względna'         : { 'nom' : _('względna'),         'gen' : _('względnej'),         'inst' : _('względną') },
        #'zaimki'           : { 'nom' : _('zaimki'),           'gen' : _('zaimków'),           'inst' : _('zaimkami') },
        'zależna'          : { 'nom' : _('zależna'),          'gen' : _('zależnej'),          'inst' : _('zależną') },
        'zdaniowa'         : { 'nom' : _('zdaniowa'),         'gen' : _('zdaniowej'),         'inst' : _('zdaniową') },
        #''       : { 'nom' : _(''),       'gen' : _(''),       'inst' : _('') },
    }

def make_inflected_string(pattern, case):
    template, words = pattern[0], pattern[1:]
    inflected = INFLECTED()
    kwargs = { 'a{}'.format(i + 1) : inflected[w][case] for i, w in enumerate(words) }
    return template % kwargs
