import json

from django.http import JsonResponse

from common.decorators import ajax_required
from entries.polish_strings import EXAMPLE_SOURCE, EXAMPLE_OPINION
from entries.views import get_scroller_params, get_alternations, get_prefs_list, schema2dict, frame2dict
from semantics.models import Frame
from syntax.models import Schema
from unifier.models import UnifiedFrameArgument, UnifiedRelationalSelectionalPreference, UnifiedFrame, \
    UnifiedFrame2SlowalFrameMapping, UnifiedFrameArgumentSlowalFrameMapping


@ajax_required
def save_synset_preference(request):
    if request.method == 'POST':
        frame_id = request.POST['frame_id']
        complement_id = request.POST['complement_id']
        synset_preference_id = request.POST['synset_preference_id']

        unifiedFrameArgument = UnifiedFrameArgument.objects.get(unified_frame_id=int(frame_id), id=int(complement_id))
        unifiedFrameArgument.synsets.add(int(synset_preference_id))
        unifiedFrameArgument.save()
    return JsonResponse({})

@ajax_required
def save_predefined_preference(request):
    if request.method == 'POST':
        frame_id = request.POST['frame_id']
        complement_id = request.POST['complement_id']
        predefined_preference_id = request.POST['predefined_preference_id']

        unifiedFrameArgument = UnifiedFrameArgument.objects.get(unified_frame_id=int(frame_id), id=int(complement_id))
        unifiedFrameArgument.predefined.add(int(predefined_preference_id))
        unifiedFrameArgument.save()
    return JsonResponse({})

@ajax_required
def save_relational_selectional_preference(request):
    if request.method == 'POST':
        frame_id = request.POST['frame_id']
        complement_id_from = request.POST['complement_id_from']
        complement_id_to = request.POST['complement_id_to']
        relation_id = request.POST['relation_id']

        unifiedFrameArgument = UnifiedFrameArgument.objects.get(unified_frame_id=int(frame_id), id=int(complement_id_from))
        relationalSelectionalPreference = UnifiedRelationalSelectionalPreference(to_id=complement_id_to, relation_id=relation_id)
        relationalSelectionalPreference.save()
        unifiedFrameArgument.relations.add(relationalSelectionalPreference)
        unifiedFrameArgument.save()
    return JsonResponse({})


@ajax_required
def get_unified_frames(request):
    if request.method == 'POST':
        scroller_params = get_scroller_params(request.POST)

        unifiedFrame2SlowalFrameMappings = UnifiedFrame2SlowalFrameMapping.objects.all();

        res = {}
        for mapping in unifiedFrame2SlowalFrameMappings:
            res[mapping.unified_frame.id] = res.get(mapping.unified_frame.id, [])
            res[mapping.unified_frame.id].append(mapping)

        resProcessed = []
        for key, value in res.items():
            title = value[0].unified_frame.title if value[0].unified_frame.title is not None else '['+value[0].slowal_frame.lexical_units.first().base+']'
            resProcessed.append({
                'id': str(value[0].unified_frame.id),
                'title': title,
                'status': value[0].unified_frame.status,
                'assignee_username': (
                    assignment.user.username if (assignment := value[0].slowal_frame.assignments.first()) else None
                ),
            })

        ret = {
                'draw' : scroller_params['draw'],
                'recordsTotal': len(resProcessed),
                'recordsFiltered': len(resProcessed),
                'data': resProcessed
        }

        return JsonResponse(ret)
    return JsonResponse({})



def unifiedFrame2dict(frame):
    return {
        'id'            : frame.id,
        'title'            : frame.title,
        'status'            : str(frame.status),
        'arguments'     : [
            {
                'str'         : str(a),
                'id'          : a.id,
                'role'        : '{}{}'.format(a.role.role.role.lower(), ' ' + a.role.attribute.attribute.lower() if a.role.attribute else '') if a.role is not None else None,
                'role_type'   : a.role_type.type.lower(),
                'preferences' : get_prefs_list(a),
                'proposed_roles': [{
                    'role'        : '{}{}'.format(r.role.role.lower(), ' ' + r.attribute.attribute.lower() if r.attribute else ''),
                } for r in a.proposed_roles.all()],
            } for a in frame.unified_arguments.all()
        ],

        'slowal_frame_mapping': [
            {
                'slowal_frame_id': slowal_frame_mapping.slowal_frame.id,
                'slowal_frame_argument_mapping': [
                    {
                        'unified_frame_agrument_id': slowal_frame_arg_mapping.unified_agrument.id,
                        'slowal_frame_agrument_id': slowal_frame_arg_mapping.slowal_agrument.id,
                    } for slowal_frame_arg_mapping in slowal_frame_mapping.unified_frame_argument_mapping.all()
                ]
            } for slowal_frame_mapping in frame.unified_frame_2_slowal_frame.all()
        ]

    }

def get_examples(frames):
    examples = []
    for frame in frames:
        for argument in frame.arguments.all():
            for connection in argument.example_connections.all():
                example = connection.example
                frame_ids, argument_ids, lu_ids, schema_ids, phrases, phrases_syntax, positions = set(), set(), set(), set(), set(), set(), set()
                for connection in example.example_connections.all():
                    for argument in connection.arguments.all():
                        frame_ids.add(argument.frame.id)
                        argument_ids.add('{}-{}'.format(argument.frame.id, argument.id))
                    if connection.lexical_unit:
                        lu_ids.add(connection.lexical_unit.id)
                    for hook in connection.schema_connections.all():
                        schema_ids.add(hook.schema.id);
                        phrases.add('{}-{}-{}-{}'.format(hook.schema.id, hook.position.id, hook.phrase_type.id, hook.alternation - 1))
                        phrases_syntax.add('{}-{}-{}'.format(hook.schema.id, hook.position.id, hook.phrase_type.id))
                        positions.add('{}-{}'.format(hook.schema.id, hook.position.id))
                elem = {
                    'id'             : str(example.id),
                    'sentence'       : example.sentence,
                    'source'         : EXAMPLE_SOURCE()[example.source.key],
                    'opinion'        : EXAMPLE_OPINION()[example.opinion.key],
                    'note'           : example.note,
                    'frame_ids'      : sorted(frame_ids),
                    'argument_ids'   : sorted(argument_ids),
                    'lu_ids'         : sorted(lu_ids),
                    'schema_ids'     : sorted(schema_ids),
                    'phrases'        : sorted(phrases),
                    'phrases_syntax' : sorted(phrases_syntax),
                    'positions'      : sorted(positions),
                }
                if elem not in examples:
                    examples.append(elem)
    return sorted(examples, key=lambda x: x['sentence'])

def get_unified_frame_json(unifiedFrame, request):

    slowal_frames_and_verified = [(connection.slowal_frame, connection.verified) for connection in unifiedFrame.unified_frame_2_slowal_frame.all()]

    slowal_frames = [tuple[0] for tuple in slowal_frames_and_verified]

    all_schema_objects = Schema.objects.filter(schema_hooks__argument_connections__argument__frame__in=slowal_frames).distinct()

    slowal_frames_dict = []
    for slowal_frame_and_verified in slowal_frames_and_verified:
        slowal_frame = slowal_frame_and_verified[0]
        verified = slowal_frame_and_verified[1]
        dict = frame2dict(slowal_frame, slowal_frame.lexical_units.all())
        dict['verified'] = verified
        slowal_frames_dict.append(dict)

    alternations, realisation_phrases, realisation_descriptions = get_alternations(all_schema_objects, slowal_frames)
    examples = get_examples(slowal_frames)

    all_schema_objects_dict = [schema2dict(schema, schema.subentries.all()[0].negativity, request.LANGUAGE_CODE) for schema in all_schema_objects]

    subentries = [{
        'str': None,
        'schemata': all_schema_objects_dict
    }]

    unifiedFrame_dict = unifiedFrame2dict(unifiedFrame)

    return { 'unified_frame_id': unifiedFrame.id, 'unified_frame': unifiedFrame_dict, 'subentries': subentries, 'frames' : slowal_frames_dict, 'alternations' : alternations, 'realisation_phrases' : realisation_phrases, 'realisation_descriptions' : realisation_descriptions, 'examples' : examples, 'last_visited' : request.session['last_visited'] }

@ajax_required
def get_unified_frame(request):
    if request.method == 'POST':
        #TODO (*)
        #form = EntryForm(request.POST)
        unified_frame_id = request.POST['unified_frame_id']
        #TODO (*)
        if unified_frame_id.isdigit():# and form.is_valid():
            unified_frame_id = int(unified_frame_id)
            request.session.modified = True
            unifiedFrame = UnifiedFrame.objects.get(id=unified_frame_id)
            return JsonResponse(get_unified_frame_json(unifiedFrame, request))

    return JsonResponse({})

@ajax_required
def extract_frames_to_new_frame(request):
    if request.method == 'POST':
        unified_frame_id = request.POST['unified_frame_id']
        new_unified_frame_id = request.POST['new_unified_frame_id']
        slowal_frame_ids = json.loads(request.POST['slowal_frame_ids'])
        unified_frame = UnifiedFrame.objects.get(id=unified_frame_id)
        slowal_frames = Frame.objects.filter(id__in=slowal_frame_ids)
        new_unified_frame = None
        if new_unified_frame_id != '':
            new_unified_frame = UnifiedFrame.objects.get(id=new_unified_frame_id)
        new_frame_fullfiled_and_saved = unified_frame.extract_frames_to(slowal_frames=slowal_frames, new_frame=new_unified_frame)
        return JsonResponse(get_unified_frame_json(new_frame_fullfiled_and_saved, request))
    return JsonResponse({})

@ajax_required
def change_slowal2unified_fram_argument_mapping(request):
    if request.method == 'POST':
        unified_frame_id = request.POST['unified_frame_id']
        slowal_frame_id = request.POST['slowal_frame_id']
        slowal_frame_selected_arguments = json.loads(request.POST['slowal_frame_selected_arguments'])


        unifiedFrame2SlowalFrameMapping = UnifiedFrame2SlowalFrameMapping.objects.get(unified_frame_id=unified_frame_id, slowal_frame=slowal_frame_id)

        arg1_id = int(slowal_frame_selected_arguments[0])
        arg2_id = int(slowal_frame_selected_arguments[1])

        unifiedFrameArgumentMapping1 = UnifiedFrameArgumentSlowalFrameMapping.objects.get(unified_frame_mapping=unifiedFrame2SlowalFrameMapping,
                                                                                             slowal_agrument_id=arg1_id) if arg1_id >= 0 else None
        unifiedFrameArgumentMapping2 = UnifiedFrameArgumentSlowalFrameMapping.objects.get(unified_frame_mapping=unifiedFrame2SlowalFrameMapping,
                                                                                          slowal_agrument_id=arg2_id) if arg2_id >= 0 else None

        if unifiedFrameArgumentMapping1 is not None and unifiedFrameArgumentMapping2 is not None:
            #mamy oba argumenty, zamieniamy miescami
            unifiedFrameArgumentMapping1.slowal_agrument_id = arg2_id
            unifiedFrameArgumentMapping2.slowal_agrument_id = arg1_id
            unifiedFrameArgumentMapping1.save()
            unifiedFrameArgumentMapping2.save()
        elif unifiedFrameArgumentMapping1 is not None and unifiedFrameArgumentMapping2 is None:
            #mamy lewy argument, prawy jest Empty
            unifiedFrameArgumentMapping1.unified_agrument_id = -arg2_id
            unifiedFrameArgumentMapping1.save()
        elif unifiedFrameArgumentMapping1 is None and unifiedFrameArgumentMapping2 is not None:
            #mamy prawy argument, lewy jest Empty
            unifiedFrameArgumentMapping2.unified_agrument_id = -arg1_id
            unifiedFrameArgumentMapping2.save()

        return JsonResponse({})
    return JsonResponse({})

@ajax_required
def change_slowal2unified_mapping_verification(request):
    if request.method == 'POST':
        unified_frame_id = request.POST['unified_frame_id']
        slowal_frame_id = request.POST['slowal_frame_id']
        verified = request.POST['verified']

        unifiedFrame2SlowalFrameMapping = UnifiedFrame2SlowalFrameMapping.objects.get(unified_frame_id=unified_frame_id, slowal_frame=slowal_frame_id)

        unifiedFrame2SlowalFrameMapping.verified = True if verified == 'true' else False
        unifiedFrame2SlowalFrameMapping.save()
        return JsonResponse({})
    return JsonResponse({})
