function update_entries() {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (data) {
        return (
            data
            && data.lexical_units
            && data.lexical_units.some(lu => lu.assignee_username === window.USER_USERNAME && lu.status == 'O')
        ) ? gettext("tak") : gettext("nie");
    }

    var datatable = setup_datatable({
        url: '/' + lang + '/entries/get_entries/?with_lexical_units=true',
        columns: [
            { data: 'lemma' },
            { data: 'POS' },
            { render: data => (data && data.lexical_units && data.lexical_units.some(lu => lu.assignee_username !== null)) ? gettext("nie") : gettext("tak") },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
        ]
    });
    datatable.on('click', 'tr.entry', function () {
        var row = datatable.row(this);
        var has_drilldown = row.child.isShown();
        $('.drilldown:visible').each(function () { datatable.row($(this).data("row")).child.hide(); });
        if (!has_drilldown) {
            if (!row.data()) return;
            var drilldown = $("<div>").addClass("drilldown").data("row", this);
            row.child(drilldown).show();
            setup_lexical_units_table(drilldown, row.data().lexical_units, can_see_assignees);
            drilldown.closest("td").addClass("p-0 pl-4");
        }
    });
}

function setup_lexical_units_table(drilldown, lexical_units, can_see_assignees) {
    if (!lexical_units.length) {
        return '';
    }

    function get_lexical_unit_row(lexical_unit) {
        const is_assigned_to_user = lexical_unit.assignee_username === window.USER_USERNAME;
        return $(`
            <tr class="lexical-unit">
                <td class="p-1">${lexical_unit.display}</td>
                <td class="p-1">${lexical_unit.status}</td>
                ` + (
                    can_see_assignees
                        ? `<td class="p-1">${lexical_unit.assignee_username || ""}</td>`
                        : `<td class="p-1">${is_assigned_to_user ? gettext("tak") : gettext("nie")}</td>`
                ) + `
            </tr>
        `).click(function () {
            $(this).addClass('table-primary').siblings().removeClass("table-primary");
            get_lexical_unit(lexical_unit.pk, $(drilldown.data("row")).data("entry"));
        });
    }
    var table = $(`
        <table class="table">
            <thead>
                <tr>
                    <th class="p-1">${gettext("Jednostka Leksykalna")}</th>
                    <th class="p-1">${gettext("Status")}</th>
                    ` + (
                        can_see_assignees
                            ? `<th class="p-1">${gettext("Leksykograf")}</th>`
                            : `<th class="p-1">${gettext("Moje")}</th>`
                    ) + `
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    `);
    drilldown.append(table);
    lexical_units.map(function (lexical_unit) {
        $("tbody", table).append(get_lexical_unit_row(lexical_unit));
    });
}

function setup_notes($container, $template, lexical_unit_pk, entry_pk) {
    $container.html($template.children().clone());
    $('.show-note-form', $container).click(function () {
        $('.note-form', $container).html($('#note-form-template > div', $container).clone());
        $('.hide-note-form', $container).click(function () { $('.note-form', $container).html(''); });
        $('.add-note', $container).click(function () {
            console.log($('textarea[name=note]', $container).val());
            $.ajax({
                type     : 'post',
                url      : $('#note-form-template').data('url').replace('MODEL', 'meanings.LexicalUnit').replace('PK', lexical_unit_pk),
                dataType : 'json',
                data     : { note: $('.note-form textarea[name=note]').val() },
                timeout  : 5000,
                success  : function (response) {
                    get_lexical_unit(lexical_unit_pk, entry_pk);
                },
                error    : function () {
                    alert(gettext('Nie udało się dodać notatki.'));
                }
            });
        });
        return false
    });
    $.ajax({
        type: 'get',
        url: $('.notes-table').data('url').replace('MODEL', 'meanings.LexicalUnit').replace('PK', lexical_unit_pk),
        success: function (data) {
            data.notes.map(function (note) {
                $('.notes-table tbody', $container).append(`<tr><td>${note.note}</td><td>${note.owner_label}</td></tr>`);
            });
        }
    })
}

function setup_unified_frame($container, frame, unified_frame, refresh) {
    $container.html('');
    if (unified_frame) {
        var $button_container = $('<div>').addClass("text-center");
        var $button = $('<a>').addClass('btn btn-sm btn-outline-dark mr-2');
        function go_to_unified_frame () {
            window.location = `/${window.lang}/entries/unification_frames`;  // TODO redirect properly
        }
        function invalid () {
            $.ajax({
                type     : 'post',
                url      : `/${lang}/semantics/frame_mark_as_invalid/${frame.id}/`,
                dataType : 'json',
                timeout  : 60000,
            }).then(refresh);
        }
        function take () {
            $.ajax({
                type     : 'post',
                url      : `/${lang}/semantics/frame_assign/${frame.id}/`,
                dataType : 'json',
                timeout  : 60000,
            }).then(go_to_unified_frame);
        }
        function confirm_invalid () {
            $.ajax({
                type     : 'post',
                url      : `/${lang}/semantics/frame_confirm_invalid/${frame.id}/`,
                dataType : 'json',
                timeout  : 60000,
            }).then(refresh);
        }
        function reject_invalid () {
            $.ajax({
                type     : 'post',
                url      : `/${lang}/semantics/frame_reject_invalid/${frame.id}/`,
                dataType : 'json',
                timeout  : 60000,
            }).then(refresh);
        }
        if (frame.status === 'N') {
            $button_container.append($button.clone().html(gettext("Błędna")).click(invalid));
            $button_container.append($button.clone().html(gettext("Pobierz")).click(take));
        } else if (frame.status === 'O') {
            $button_container.append($button.clone().html(gettext("Obrabiaj")).click(go_to_unified_frame));
        } else if (frame.status === 'G' && unified_frame.status === 'O') {
            $button_container.append($button.clone().html(gettext("Obrabiaj")).click(go_to_unified_frame));
        } else if (frame.status === 'S' && unified_frame.status === 'S') {
            $button_container.append($button.clone().html(gettext("Obejrzyj")).click(go_to_unified_frame));
        } else if (frame.status === 'B' && has_permission('semantics.manage_invalid_lexical_units')) {
            $button_container.append($button.clone().html(gettext("Potwierdź")).click(confirm_invalid));
            $button_container.append($button.clone().html(gettext("Odrzuć")).click(reject_invalid));
        }
        $container.append($button_container);
    } else {
        $container.append($('<p>').html(gettext("Brak ramy unifikacyjnej.")));
    }
}

function get_lexical_unit(lexical_unit_pk, entry_pk) {
    $('#lexical-unit-notes').html('');
    $('#unified-frame').html('');
    get_entry(entry_pk, false, lexical_unit_pk).then(function (entry) {
        var frame = entry.frames[0];
        setup_unified_frame(
            $('#unified-frame'),
            frame,
            entry.unified_frame,
            function () { get_lexical_unit(lexical_unit_pk, entry_pk); update_entries(); }
        );
        setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), lexical_unit_pk, entry_pk);
    });
}
