"use strict";

var unified_view_frame_content;
var curr_unified_frame;


function change_slowal2unified_fram_argument_mapping(slowal_frame_id) {
    var argument_ids = [];
    $('.argument.active').each(function() {
        var id = $(this).data('argument_id').split('-')[1];
        if(id.startsWith('_')) {
            id = -parseInt(id.split('_')[1])
        } else {
            id = parseInt(id)
        }
        argument_ids.push(id);
    });
    var choosed_slowal_frame_id = null;
    $('.frame.active').each(function() {
        choosed_slowal_frame_id = $(this).data('frame_id');
    });
    if(choosed_slowal_frame_id == slowal_frame_id && argument_ids.length == 2) {
        change_slowal2unified_fram_argument_mapping_post(curr_unified_frame.id, choosed_slowal_frame_id, argument_ids);
        get_unified_frame(curr_unified_frame.id);
    }
}

function frames2dom_unidief_view(frames) {
    var fragment = document.createDocumentFragment();
    for (var i in frames) {
        let frameDiv = frame2dom(frames[i]);
        var table = document.createElement('table');
        table.className = 'table m-0 table-borderless border border-secondary text-dark';
        var tbody = document.createElement('tbody');

        // roles and selectional preferences
        var roles_row = document.createElement('tr');

        var frame_col = document.createElement('th');
        frame_col.scope = 'row';
        frame_col.class = 'py-0 px-1 text-secondary';
        frame_col.append(frameDiv)

        var button_col = document.createElement('th');
        button_col.scope = 'row';
        button_col.class = 'py-0 px-1 text-secondary';

        var button_col_div = document.createElement('div');
        button_col_div.innerHTML = '<div class="custom-control custom-checkbox">\n' +
            '    <input type="checkbox" id="defaultUnchecked" class="custom-control-input" '+(frames[i].verified ? 'checked' : '')+' onclick="change_slowal2unified_mapping_verification('+frames[i].id+', this.checked)">\n' +
            '    <label class="custom-control-label" for="defaultUnchecked">Zweryfikowane</label>\n' +
            '    <br><br>' +
            '    <a href="#" class="btn btn-sm btn-dark" role="button" onclick="change_slowal2unified_fram_argument_mapping('+frames[i].id+')">Z</a>' +
            '</div>';

        button_col.append(button_col_div);

        roles_row.append(frame_col);
        roles_row.append(button_col);
        tbody.append(roles_row);
        table.append(tbody);

        fragment.append(table);

    }
    if (fragment.childNodes.length === 0) {
        return '<p>(' + gettext('brak ram') + ')</p>';
    }
    return fragment;
}

function show_semantics_unified_view(frames, subentries) {
    $('#semantics-no-examples').hide();
    var schemata_dom = subentries2dom(subentries);
    $('#semantics-schemata').append($(schemata_dom));
    var frames_dom = frames2dom_unidief_view(frames);

    $('#semantics-frames').append($(frames_dom));

    $('.frame').mouseenter(function() {
        var frame = $(this);
        if (!frame.hasClass('active')) {
            $(this).addClass('highlight bg-highlight');
            show_info(gettext('Kliknij, aby wyświetlić przykłady dla tej ramy oraz jej realizacje składniowe.'));
        }
    }).mouseleave(function() {
        $(this).removeClass('highlight bg-highlight');
        clear_info();
    }).click(function() {
        var frame = $(this);
        if (!frame.hasClass('active')) {
            select_frame(frame);
        }
        clear_info();
    });

    $('.lu-plwn, .synset-plwn').click(function(event) {
        // don’t make link click select the frame
        event.stopPropagation();
    });

    // if there’s one frame, select it immediately
    if ($('.frame').length === 1) {
        select_frame($('.frame').first());
    }

    // if there’s no frames, disable the tab
    if ($('.frame').length === 0) {
        $('#semantics-tab').addClass('disabled');
    } else {
        $('#semantics-tab').removeClass('disabled');
    }
}


function change_slowal2unified_fram_argument_mapping_post(unified_frame_id, slowal_frame_id, slowal_frame_selected_arguments) {
    check_import_status();
    show_entry_spinners();
    var data = { 'unified_frame_id' : unified_frame_id, 'slowal_frame_id' : slowal_frame_id, 'slowal_frame_selected_arguments' : JSON.stringify(slowal_frame_selected_arguments) };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/change_slowal2unified_fram_argument_mapping/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {

        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function change_slowal2unified_mapping_verification(slowal_frame_id, verified) {
    check_import_status();
    show_entry_spinners();
    var data = { 'unified_frame_id' : curr_unified_frame.id, 'slowal_frame_id' : slowal_frame_id, 'verified' : verified };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/change_slowal2unified_mapping_verification/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {

        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}


function get_unified_frame(unified_frame_id, related) {
    check_import_status();
    clear_entry();
    show_entry_spinners();
    //var data = { 'forms' : serialize_forms($('#main-form')), 'entry' : entry_id };
    var data = { 'unified_frame_id' : unified_frame_id, 'no_filters' : related };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/get_unified_frame/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            curr_unified_frame = response.unified_frame;
            unified_view_frame_content = response.frames
            curr_entry = unified_frame_id;
            curr_no_filters = related;
            clear_info();
            curr_alternations = response.alternations;
            curr_realisation_phrases = response.realisation_phrases;
            curr_realisation_descriptions = response.realisation_descriptions;
            curr_examples = response.examples;
            curr_examples_by_id = Object();
            for (var i in curr_examples) {
                curr_examples_by_id[curr_examples[i].id] = curr_examples[i];
            }
            // show_syntax(response.subentries);
            show_unified_frame(response.unified_frame, response.frames)
            show_unified_frame_lexical_units(response.frames)
            fulfill_slowal_frames_arguments_with_empty_elems(response.unified_frame, response.frames)
            show_semantics_unified_view(response.frames, response.subentries);
            // show_unmatched_examples();

            // if current tab is empty, switch to an active tab
            var active_tab = $('#entryTabs').find('.nav-link.active').attr('id');
            if (active_tab === 'semantics-tab' && $('.frame').length === 0) {
                // current tab is semantics -> show syntax
                $('#syntax-tab').tab('show');
            } else if (active_tab === 'examples-tab') {
                if ($('.frame').length > 0) {
                    // current tab is examples, semantics nonempty -> show semantics
                    $('#semantics-tab').tab('show');
                } else {
                    // current tab is examples, semantics empty -> show syntax
                    $('#syntax-tab').tab('show');
                }
            }

            // tooltips with meaning gloss
            activate_tooltips($('#semantics-frames-pane'));
            update_last_visited(response.last_visited);
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}


function slowal_frames2selecional_preferencies(unified_frame, slowal_frames) {
    var unified_argument_2_selecional_preferencies = {}
    for (var i in unified_frame.slowal_frame_mapping) {
        var slowal_frame_mapping = unified_frame.slowal_frame_mapping[i];
        let slowal_frame = slowal_frames.find(o => o.id === slowal_frame_mapping.slowal_frame_id);
        for (var j in slowal_frame_mapping.slowal_frame_argument_mapping) {
            var slowal_frame_argument_mapping = slowal_frame_mapping.slowal_frame_argument_mapping[j];

            let slowal_frame_argument = slowal_frame.arguments.find(o => o.argument_id === slowal_frame_argument_mapping.slowal_frame_agrument_id);

            let preferenceEntry = unified_argument_2_selecional_preferencies[slowal_frame_argument_mapping.unified_frame_agrument_id];
            if(preferenceEntry == null) {
                preferenceEntry = [];
                unified_argument_2_selecional_preferencies[slowal_frame_argument_mapping.unified_frame_agrument_id] = preferenceEntry
            }
            preferenceEntry.push.apply(preferenceEntry, slowal_frame_argument.preferences)
        }
    }
    return unified_argument_2_selecional_preferencies;
}


function fulfill_slowal_frames_arguments_with_empty_elems(unified_frame, slowal_frames) {
    for (var i in unified_frame.slowal_frame_mapping) {
        var slowal_frame_mapping = unified_frame.slowal_frame_mapping[i];
        let slowal_frame = slowal_frames.find(o => o.id === slowal_frame_mapping.slowal_frame_id);
        let new_slowal_frame_arguments = [];
        for (var j in unified_frame.arguments) {
            var unified_frame_argument = unified_frame.arguments[j];

            let unified_frame_argument_mapping = slowal_frame_mapping.slowal_frame_argument_mapping.find(o => o.unified_frame_agrument_id === unified_frame_argument.id);

            let slowal_frame_argument = null;

            if(unified_frame_argument_mapping == null) {
                slowal_frame_argument = {
                    'str'         : 'Empty',
                    'id'          : slowal_frame.id+'-_'+(unified_frame_argument.id),
                    'role'        : 'Empty',
                    'role_type'   : 'Empty',
                    'preferences' : [],
                    'proposed_roles': [],
                }
            } else {
                slowal_frame_argument = slowal_frame.arguments.find(o => o.argument_id === unified_frame_argument_mapping.slowal_frame_agrument_id);
            }

            new_slowal_frame_arguments.push(slowal_frame_argument)
        }
        slowal_frame.arguments = new_slowal_frame_arguments;
    }
}

function unifiedFrame2dom(unifiedFrame, slowal_frames) {
    var div = document.createElement('div');
    div.className = 'unifiedFrame mb-3';
    div.setAttribute('data-frame_id', unifiedFrame.id);

    var p = document.createElement('p');
    p.className = 'mb-1'

    let title = unifiedFrame.title;
    if(title == null) {
        //title as list of lexical units from all slowal frames
        var lexical_units = frames2lexical_units(slowal_frames);
        var lexical_units_html = lexical_units2dom(lexical_units);
        title = lexical_units_html;
    }

    p.innerHTML = '<span class="lexical-unit' + cls + '">' + title + '</span>';
    div.append(p)

    let slowal_frames2selecional_preferencies_mapping = slowal_frames2selecional_preferencies(unifiedFrame, slowal_frames);

    var table = document.createElement('table');
    table.className = 'table m-0 table-borderless border border-secondary text-dark';
    var tbody = document.createElement('tbody');

    // roles and selectional preferences
    var roles_row = document.createElement('tr');
    var roles_html = '<th scope="row" class="py-2 px-1 text-secondary">' + gettext('Rola') + '</td>';
    var preferences_row = document.createElement('tr');
    var preferences_html = '<th scope="row" class="py-0 px-1 text-secondary">' + gettext('Preferencje selekcyjne') + '</td>';
    for (var i in unifiedFrame.arguments) {
        var argument = unifiedFrame.arguments[i];
        var cls = '';
        var data = ' data-argument_id="' + argument.id + '" data-role="' + argument.role + '"';
        roles_html += '<td class="argument py-2 px-1 border-top border-left border-secondary' + cls + ' ' + argument.role_type + '"' + data + '>' + argument.role_type;
        roles_html += '<ul>'
        for (var j in argument.proposed_roles) {
            var proposed_role = argument.proposed_roles[j];
            roles_html += '<li>' + proposed_role.role + '</li>';
        }
        roles_html += '</ul>'
        roles_html += '</td>'

        preferences_html += '<td class="preferences py-0 px-0 border-top border-left border-secondary' + cls + '"' + data + '>'

        // don’t append to preferences_html.innerHTML since it automatically closes tags *** (?)
        let selectional_preference_html = create_selectional_preference_html(argument.preferences, 'preference-bold');
        preferences_html += selectional_preference_html;

        let selecional_preferencies_poposition = slowal_frames2selecional_preferencies_mapping[argument.id]
        if(selecional_preferencies_poposition != null) {
            let selectional_preference_proposition_html = create_selectional_preference_html(selecional_preferencies_poposition, '');
            preferences_html += selectional_preference_proposition_html;
        }

        // *** and we want to close the <td> here
        preferences_html += '</td>';
    }
    preferences_row.innerHTML += preferences_html;
    roles_row.innerHTML = roles_html;
    tbody.append(roles_row);
    tbody.append(preferences_row);
    table.append(tbody);
    div.append(table);
    return div;
}

function create_selectional_preference_html(preferences, additioan_css_class) {
    let preferences_html_local = '';
    for (var j in preferences) {
        var preference = preferences[j];
        var cls = j > 0 ? ' border-top' : '';
        if (preference.str.length > 12) {
            cls += ' text-break';
        }
        preferences_html_local += '<div class="preference py-2 px-1' + cls + '">';
        if (preference.url) {
            preferences_html_local += ' <a class="synset-plwn '+additioan_css_class+'" href="' + preference.url + '" target="_blank">' + preference.str + '</a>';
        } else {
            preferences_html_local +=  ' <span class="'+additioan_css_class+'">' + preference.str +'</span>';
        }
        if (preference.info) {
            preferences_html_local += ' ' + tooltipped_info(preference.info);
        }
        preferences_html_local += '</div>';
    }
    return preferences_html_local;
}


function frames2lexical_units(frames) {
    var lexical_units = []
    for (var i in frames) {
        var frame = frames[i];
        for (var j in frame.lexical_units) {
            var lexical_unit = frame.lexical_units[j];
            lexical_unit.opinion = frame.opinion;
            lexical_unit.opinion_key = frame.opinion_key;
            lexical_units.push(lexical_unit);
        }
    }
    return lexical_units;
}

function frames2lexical_unitsHTML(frames) {
    var div = document.createElement('div');
    div.className = 'frame mb-3';
    var lexical_units = frames2lexical_units(frames)
    var table = document.createElement('table');
    table.className = 'table m-0 table-borderless border border-secondary text-dark';
    var tbody = document.createElement('tbody');

    var header_row = document.createElement('tr');
    header_row.innerHTML += '<th scope="row" class="py-2 px-1 text-secondary">' + gettext('Jednostka leksykalna') + '</td>';
    header_row.innerHTML += '<th scope="row" class="py-2 px-1 text-secondary">' + gettext('Opinia') + '</td>';
    tbody.append(header_row);

    for (var j in lexical_units) {
        let lexical_unit = lexical_units[j];
        let lexical_unit_row = document.createElement('tr');
        lexical_unit_row.innerHTML += '<td class="argument py-2 px-1 border-top border-left border-secondary">' + gettext(lexical_unit.str) + '</td>';
        lexical_unit_row.innerHTML += '<td class="argument py-2 px-1 border-top border-left border-secondary">' + '<img src="' + window.STATIC_URL + 'entries/img/' + lexical_unit.opinion_key + '.svg" width="12" height="12" alt="' + lexical_unit.opinion + '"> ' + gettext(lexical_unit.opinion) + '</td>';
        tbody.append(lexical_unit_row);
    }
    table.append(tbody);
    div.append(table);

    return div;
}

function show_unified_frame(unified_frame, slowal_frames) {
    var unified_frame_dom = unifiedFrame2dom(unified_frame, slowal_frames);
    $('#unified-frame').empty();
    $('#unified-frame').append($(unified_frame_dom));
}

function show_unified_frame_lexical_units(frames) {
    var lexical_units_dom = frames2lexical_unitsHTML(frames);
    $('#unified-frame-lexical-units').empty();
    $('#unified-frame-lexical-units').append($(lexical_units_dom));
}

function extract_frames_to_new_frame(unified_frame_id, slowal_frame_ids, new_unified_frame_id) {
    check_import_status();
    clear_entry();
    show_entry_spinners();
    var data = { 'unified_frame_id' : unified_frame_id, 'slowal_frame_ids' : JSON.stringify(slowal_frame_ids), 'new_unified_frame_id': new_unified_frame_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/extract_frames_to_new_frame/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            unified_frame_id = response.unified_frame_id;

        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

