var predefined = [];
var relations = [];
var synsets = [];
var change = false;

function predefinedSelect() {
    var display = "";

    var i;
    for (i = 0; i < predefined.length; i++) {
        display += "<input type = \"checkbox\" name = \"predef\" value = \"" + predefined[i].id + "\">" + predefined[i].content + "<br>";
    }

    return display;
}

function getPredefinedSelections() {
    $.ajax({
        dataType: "json",
        url: 'predefined_preferences',
        success: function(data){
            predefined = data.predefined;
        },
        async: false
    });
}

function memorizeRelations(new_relations) {
    relations = new_relations;
}

function relationsSelect() {
    var display = "<select name = \"rel\">";

    var i;
    for (i = 0; i < relations.length; i++) {
        display += "<option value = \"" + relations[i].id + "\">" + relations[i].content + "</option>";
    }
    display += "</select>"
    return display;
}

function argumentSelect(frame, complement_id) {
    var display = "<select name = \"arg\">";

    var i;
    for (i = 0; i < frame.arguments.length; i++) {
        var local_complement_id = parseInt(frame.arguments[i].id.split('-')[1]);
        if (local_complement_id != complement_id) {
            // var list = frame_content[unified_frame_id].display.roles[i].argument;
            //
            // var text = [];
            // var j;
            // for (j = 0; j < list.length; j++) {
            //     text.push(role_name[list[j]]);
            // }
            // display += "<option value = \"" + list + "\">" + text + "</option>";

            // var text = [];
            // text.push(frame.arguments[i].role);

            display += "<option value = \"" + local_complement_id + "\">" + frame.arguments[i].role + "</option>";
        }
    }

    display += "</select>"

    return display;
}

function getSynsets(context, pos) {

    if ((typeof pos) == 'undefined') {
        pos = '_';
    }

    $.ajax({
        dataType: "json",
        url: 'synsets',
        data: {base: context, pos: pos},
        success: function(data){ synsets = data.synsets },
        async: false
    });

    var display = "";

    var i;
    for (i = 0; i < synsets.length; i++) {
        display += "<input type = \"radio\" name = \"synset\" value = \"" + synsets[i].id + "\"><div>";
        var j;
        for (j = 0; j < synsets[i].content.length; j++) {
            var lexical_unit = synsets[i].content[j];
            display += lexical_unit.base + "-" + lexical_unit.sense + ": <i>" + lexical_unit.glossa + "</i><br>";
        }
        display += "</div>";
    }

    return display;

}

function relationArgument(frame, complement_id) {
    return relationsSelect() + "<br><br>" + argumentSelect(frame, complement_id);
}

function attachPlWNContextAutocomplete() {
    $('#plWN_context_selection').autocomplete({
        select: function(event, ui){
        },
        source: function(req, add){
            $.getJSON('plWN_context_lookup', req, function(data) {
                var suggestions = [];
                $.each(data['result'], function(i, val){
                    suggestions.push(val);
                });
                add(suggestions);
            });
        },
    });
}

function addSelectivePreference() {
    addSelectivePreferenceBase(unified_view_frame_content[0], 1)
}

function addSelectivePreferenceBase(frame, complement_id) {

    let unified_frame_id = frame.id;

    var submitSynsetSelection = function(e,v,m,f){
        if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state2');
        }
        if (v == 1) {
            e.preventDefault();
            var synset = normalizeFormData(f.synset);

            var i;
            for (i = 0; i < synset.length; i++) {
                saveSynsetPreference(unified_frame_id, complement_id, synset[i])
            }
            $.prompt.goToState('state0');
        }
    }

    var select_preference = {
        state0: {
            title: 'Typ preferencji selekcyjnej',
            html: 'Wybierz typ preferencji selekcyjnej',
            buttons: { Istniejąca: 0, Predefiniowana: 1, Słowosieć: 2, Relacja: 3, Koniec: -1 },
            focus: -1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();

                    get_unified_frame(curr_entry, false);

                    $.prompt.close();
                }
                if (v === 0) {
                    e.preventDefault();
                    $.prompt.goToState('state4');
                }
                if (v == 1) {
                    e.preventDefault();
                    $.prompt.goToState('state1');
                }
                if (v == 2) {
                    e.preventDefault();
                    $.prompt.goToState('state2');
                }
                if (v == 3) {
                    e.preventDefault();
                    $.prompt.goToState('state3');
                }
            }
        },
        state1: {
            title: 'Wybierz preferencję selekcyjną',
            html: predefinedSelect(),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){

                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();
                    var predef = normalizeFormData(f.predef);

                    var i;
                    for (i = 0; i < predef.length; i++) {
                        savePredefinedPreference(unified_frame_id, complement_id, predef[i])
                        // addPreference(unified_frame_id, complement_id, { type: 'g', content: predef[i], text: predefined[indexOfId(predefined, predef[i])].content });
                    }
                    $.prompt.goToState('state0');
                }
            }
        },
        state2: {
            title: 'Wybierz preferencję selekcyjną',
            html: "<input id=\"plWN_context_selection\" type=\"text\" name=\"context\">",
            buttons: { Anuluj: -1, Wyszukaj: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();
                    $.prompt.removeState('state21');
                    $.prompt.addState('state21', {title: 'Znaczenia', html: getSynsets(f.context), buttons: {Anuluj: -1, Zatwierdź: 1}, focus: 1, submit: submitSynsetSelection}, 'state2');
                    $.prompt.goToState('state21');
                }
            }
        },
        state3: {
            title: 'Wybierz relację i argument',
            html: relationArgument(frame, complement_id),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();

                    var rel = normalizeFormData(f.rel);
                    var args = normalizeFormData(f.arg);

                    var i, j;
                    for (i = 0; i < rel.length; i++) {
                        for (j = 0; j < args.length; j++) {
                            saveRelationalSelectionalPreference(unified_frame_id, complement_id, args[j], rel[i])
                            // addPreference(unified_frame_id, complement_id, {type: 'r', content: { relation: rel[i], to: args[j] }, text: relations[indexOfId(relations, rel[i])].content + "<br>-> [" + text + "]" });
                        }
                    }

                    $.prompt.goToState('state0');
                }
            }
        },
        state4: {
            title: 'Wybierz z istniejących',
            html: relationArgument(frame, complement_id),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();

                    // TODO

                    $.prompt.goToState('state0');
                }
            }
        },
    };
    if (change == true) {
        alertSemantics();
    } else {
        $.prompt(select_preference);
        attachPlWNContextAutocomplete();
    }

}




function saveSynsetPreference(frame_id, complement_id, synset_preference_id) {
    var data = { 'frame_id' : frame_id, 'complement_id' : complement_id, 'synset_preference_id' : synset_preference_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_synset_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function savePredefinedPreference(frame_id, complement_id, predefined_preference_id) {
    var data = { 'frame_id' : frame_id, 'complement_id' : complement_id, 'predefined_preference_id' : predefined_preference_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_predefined_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function saveRelationalSelectionalPreference(frame_id, complement_id_from, complement_id_to, relation_id) {
    var data = { 'frame_id' : frame_id, 'complement_id_from' : complement_id_from, 'complement_id_to' : complement_id_to, 'relation_id': relation_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_relational_selectional_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}


