"use strict";

//TODO clear those to null on new entry to make sure
var curr_entry = null;
var curr_alternations = null;
var curr_realisation_phrases = null;
var curr_realisation_descriptions = null;
var curr_examples = null;
var curr_examples_by_id = null;

function make_opinion_row(item, span, width) {
    var opinion_row = document.createElement('tr');
    opinion_row.className = 'opinion-row';
    opinion_row.innerHTML = '<th scope="row" class="py-2 px-1 text-secondary" style="width: ' + width + 'em;">' + gettext('Opinia') + '</td>';
    opinion_row.innerHTML += '<td class="opinion-cell py-2 px-1" colspan="' + span + '"><img src="/static/entries/img/' + item.opinion_key + '.svg" width="12" height="12" alt="' + item.opinion + '"> ' + item.opinion + '</td>';
    return opinion_row;
}

// TODO make schema2dom and frame2dom share as much code as possible
function schema2dom(schema) {
    var div = document.createElement('div');
    div.className = 'schema mb-3 inactive';
    div.setAttribute('data-schema_id', schema.id);
    var table = document.createElement('table');
    table.className = 'table m-0 table-borderless border border-secondary text-dark';
    var tbody = document.createElement('tbody');
    
    // opinion
    var opinion_row = make_opinion_row(schema, schema.positions.length, 3);
    
    // position props and phrase types
    var props_row = document.createElement('tr');
    props_row.innerHTML = '<th scope="row" class="py-2 px-1 text-secondary">' + gettext('Funkcja') + '</td>';
    var phrases_row = document.createElement('tr');
    phrases_row.className = 'phrase-types alt-0'
    var phrases_html = '<th scope="row" class="py-0 px-1 text-secondary">' + gettext('Typy fraz') + '</td>';
    for (var i in schema.positions) {
        var position = schema.positions[i];
        // position props: function, control, predicative control
        var props_td = document.createElement('td');
        props_td.className = 'position py-2 px-1 border-top border-left border-secondary';
        props_td.dataset.position_id = position.id;
        var props_spans = [];
        if (position.func.str !== '') {
            props_spans.push(tooltipped_span(position.func.str, position.func.desc, null));
        }
        if (position.control.str !== '') {
            props_spans.push(tooltipped_span(position.control.str, position.control.desc, null));
        }
        if (position.p_control.str !== '') {
            props_spans.push(tooltipped_span(position.p_control.str, position.p_control.desc, null));
        }
        props_td.innerHTML = props_spans.join(',');
        props_row.append(props_td);
        // don’t append to phrases_row.innerHTML since it automatically closes tags *** (?)
        phrases_html += '<td class="px-0 py-0 border-top border-left border-secondary">';
        for (var j in position.phrases) {
            var phrase = position.phrases[j];
            var cls = j > 0 ? ' border-top' : '';
            if (phrase.str.length > 32) {
                cls += ' text-break';
            }
            phrases_html += '<div class="phrase px-1 py-2 ' + cls + '" data-alternation="0" data-phrase_id="' + phrase.id + '">';
            phrases_html += tooltipped_span(phrase.str, phrase.desc, null) + '</div>';
        }
        // *** and we want to close the <td> here
        phrases_html += '</td>';
    }
    //alert(phrases_html);
    phrases_row.innerHTML = phrases_html;
    
    tbody.append(opinion_row);
    tbody.append(props_row);
    tbody.append(phrases_row);
    table.append(tbody);
    div.append(table);
    
    return div;
}

function subentries2dom(subentries) {
    var fragment = document.createDocumentFragment();
    for (var i in subentries) {
        var subentry = subentries[i];
        var subentry_div = document.createElement('div');
        subentry_div.className = 'subentry';
        var subentry_header = document.createElement('div');
        subentry_header.className = 'mb-1 sticky-top';
        subentry_header.innerHTML = '<h5 class="bg-dark text-light p-1">' + subentry.str + '</h5>';
        subentry_div.append(subentry_header)
        for (var j in subentry.schemata) {
            subentry_div.append(schema2dom(subentry.schemata[j]));
        }
        fragment.append(subentry_div);
    }
    if (fragment.childNodes.length === 0) {
        return '<p>(' + gettext('brak schematów') + ')</p>';
    }
    return fragment;
}

function frame2dom(frame) {
    var div = document.createElement('div');
    div.className = 'frame mb-3';
    div.setAttribute('data-frame_id', frame.id);
    
    var p = document.createElement('p');
    p.className = 'mb-1'
    var lexical_units = [];
    for (var i in frame.lexical_units) {
        var lu = frame.lexical_units[i];
        var cls = lu.entry_meaning ? ' entry-meaning' : '';
        var lu_html = '<span class="lexical-unit' + cls + '" data-lu_id="' + lu.id +  '">' + lu.str + '</span>';
        var tooltip = [];
        if (lu.definition) {
            tooltip.push(lu.definition);
        }
        if (lu.gloss) {
            tooltip.push(lu.gloss);
        }
        if (!lu.url) {
            tooltip.push(gettext('nowa jednostka spoza <i>Słowosieci</i>'));
        }
        if (tooltip.length > 0) {
            lu_html += ' ' + tooltipped_info('<i>' + tooltip.join('; ') + '</i>');
        }
        if (lu.url) {
            //lu_html += ' ' + tooltipped_span('<a href="' + lu.url + '" target="_blank"><img src="/static/common/img/plwn.svg" alt="external link" height="14"/></a>', gettext('Przejdź do strony tej jednostki w <i>Słowosieci</i>'), 'plwn-url');
            //lu_html += ' ' + tooltipped_span('<a href="' + lu.url + '" target="_blank"><img src="/static/common/img/ext-link.svg" alt="external link" height="14"/></a>', gettext('Przejdź do strony tej jednostki w <i>Słowosieci</i>'), 'plwn-url');
            lu_html += ' <a class="lu-plwn" href="' + lu.url + '" target="_blank"><img src="/static/common/img/ext-link.svg" alt="external link" height="14"/></a>';
        }
        lexical_units.push(lu_html);
    }
    p.innerHTML = lexical_units.join(', ');
    div.append(p)
    
    var table = document.createElement('table');
    table.className = 'table m-0 table-borderless border border-secondary text-dark';
    var tbody = document.createElement('tbody');
    
    // opinion
    var opinion_row = make_opinion_row(frame, frame.arguments.length, 3);
    
    // roles and selectional preferences
    var roles_row = document.createElement('tr');
    roles_row.innerHTML = '<th scope="row" class="py-2 px-1 text-secondary">' + gettext('Rola') + '</td>';
    var preferences_row = document.createElement('tr');
    var preferences_html = '<th scope="row" class="py-0 px-1 text-secondary">' + gettext('Preferencje selekcyjne') + '</td>';
    for (var i in frame.arguments) {
        var argument = frame.arguments[i];
        var cls = '';
        var data = ' data-argument_id="' + argument.id + '" data-role="' + argument.role + '"';
        roles_row.innerHTML += '<td class="argument py-2 px-1 border-top border-left border-secondary' + cls + ' ' + argument.role + '"' + data + '>' + argument.str + '</td>';
        
        // don’t append to preferences_html.innerHTML since it automatically closes tags *** (?)
        preferences_html += '<td class="preferences py-0 px-0 border-top border-left border-secondary' + cls + '"' + data + '>'
        for (var j in argument.preferences) {
            var preference = argument.preferences[j];
            var cls = j > 0 ? ' border-top' : '';
            if (preference.str.length > 12) {
                 cls += ' text-break';
            }
            preferences_html += '<div class="preference py-2 px-1' + cls + '">';
            if (preference.url) {
                //preferences_html += ' <a class="synset-plwn" href="' + preference.url + '" target="_blank"><img src="/static/common/img/ext-link.svg" alt="external link" height="14"/></a>';
                preferences_html += ' <a class="synset-plwn" href="' + preference.url + '" target="_blank">' + preference.str + '</a>';
            } else {
                preferences_html += preference.str;
            }
            if (preference.info) {
                preferences_html += ' ' + tooltipped_info(preference.info);
            }
            preferences_html += '</div>';
        }
        // *** and we want to close the <td> here
        preferences_html += '</td>';
    }
    preferences_row.innerHTML += preferences_html;
    
    tbody.append(opinion_row);
    tbody.append(roles_row);
    tbody.append(preferences_row);
    table.append(tbody);
    div.append(table);
    
    return div;
}

function frames2dom(frames) {
    var fragment = document.createDocumentFragment();
    for (var i in frames) {
        fragment.append(frame2dom(frames[i]));
    }
    if (fragment.childNodes.length === 0) {
        return '<p>(' + gettext('brak ram') + ')</p>';
    }
    return fragment;
}

function unbind_click(selector) {
    selector.unbind('mouseenter').unbind('mouseleave').unbind('click');
}

function show_syntax(subentries) {
    $('#syntax-no-examples').hide();
    var schemata_dom = subentries2dom(subentries);
    $('#syntax-schemata').append($(schemata_dom));
    
    $('#syntax-schemata').find('.schema').mouseenter(function() {
        var schema = $(this);
        if (!schema.hasClass('active')) {
            schema.addClass('bg-highlight');
            show_info(gettext('Kliknij, aby wyświetlić przykłady dla tego schematu.'));
        }
    }).mouseleave(function() {
        $(this).removeClass('bg-highlight');
        clear_info();
    }).click(function() {
        var schema = $(this);
        if (!schema.hasClass('active')) {
            select_schema(schema);
        }
        clear_info();
    });
    
    // if there’s one schema, select it immediately
    if ($('#syntax-schemata').find('.schema').length === 1) {
        select_schema($('#syntax-schemata').find('.schema').first());
    }
    
    // if there’s no schemata, disable the tab
    if ($('#syntax-schemata').find('.schema').length === 0) {
        $('#syntax-tab').addClass('disabled');
    } else {
        $('#syntax-tab').removeClass('disabled');
    }
}

function select_schema(schema) {
    if ($('#syntax-schemata').find('.schema.active').length > 0) {
        unselect_schema($('#syntax-schemata').find('.schema.active'));
    }
    schema.removeClass('bg-highlight');
    schema.addClass('active');
    show_syntax_examples(schema);
    // TODO bind position and phrase clicks and opinion click for unselect
    //bind_arguments_click(frame);
    //bind_frame_opinion_click(frame);
    schema.find('.opinion-row').mouseenter(function(event) {
        show_info(gettext('Kliknij, aby cofnąć wyświetlanie przykładów dla tego schematu.'));
        event.stopPropagation();
    }).mouseleave(function() {
        clear_info();
    }).click(function(event) {
        event.stopPropagation();
        unselect_schema(schema);
        clear_info();
    });
    schema.find('.position, .phrase').mouseenter(function() {
        var is_position = $(this).hasClass('position');
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć ograniczenie wyświetlanych przykładów do powiązanych z') + ' ' + (is_position ? gettext('tą pozycją') : gettext('tą frazą')) + '.');
        } else {
            show_info(gettext('Kliknij, aby wyświetlić wyłącznie przykłady powiązane z') + ' ' + (is_position ? gettext('tą pozycją') : gettext('tą frazą')) + '.');
        }
        $(this).addClass('bg-highlight');
        event.stopPropagation();
    }).mouseleave(function() {
        $(this).removeClass('bg-highlight');
        clear_info();
    }).click(function(event) {
        event.stopPropagation();
        var active = $(this).hasClass('active');
        if (active) {
            $(this).removeClass('active');
        } else {
            $(this).addClass('active');
        }
        // other restrictions might be active
        restrict_syntax_examples();
        clear_info();
    });
}

function unselect_schema(schema) {
    // TODO unbind position and phrase clicks and opinion click for unselect
    //unbind_arguments_click(frame);
    //unbind_frame_opinion_click(frame);
    schema.removeClass('active').find('.position, .phrase').removeClass('active');
    //schema.find('.opinion-row').removeClass('bg-highlight');
    unbind_click(schema.find('.opinion-row'));
    unbind_click(schema.find('.position'));
    unbind_click(schema.find('.phrase'));
    // TODO
    clear_curr_example(false);
    $('#syntax-examples-list').empty();
    $('#syntax-examples').hide();
}

function restrict_syntax_examples() {
    $('#syntax-examples').show();
    $('#syntax-no-examples').hide();
    $('#syntax-examples-list').find('.example').show();
    var position_ids = [];
    var phrase_ids = [];
    $('#syntax-schemata').find('.position.active').each(function() {
        position_ids.push($(this).data('position_id'));
    });
    $('#syntax-schemata').find('.phrase.active').each(function() {
        phrase_ids.push($(this).data('phrase_id'));
    });
    var lu_id = $('.entry-meaning.active').data('lu_id');
    if (!(position_ids.length || phrase_ids.length)) {
        return;
    }
    var visible_examples = 0;
    $('#syntax-examples-list').find('.example').each(function() {
        var example = curr_examples_by_id[$(this).data('example_id')];
        if (
                //(argument_id && !example.argument_ids.includes(argument_id))
                (position_ids.length && !position_ids.every(elem => example.positions.includes(elem)))
                ||
                (phrase_ids.length && !phrase_ids.every(elem => example.phrases_syntax.includes(elem)))
            ) {
            $(this).hide();
            if ($(this).hasClass('active')) {
                clear_curr_example(false);
            }
        } else {
            visible_examples += 1;
        }
    });
    if (visible_examples === 0) {
        $('#syntax-examples').hide();
        $('#syntax-no-examples').show();
    }
}

function show_semantics(frames, subentries) {
    $('#semantics-no-examples').hide();
    var schemata_dom = subentries2dom(subentries);
    $('#semantics-schemata').append($(schemata_dom));
    var frames_dom = frames2dom(frames);
    $('#semantics-frames').append($(frames_dom));
    
    $('.frame').mouseenter(function() {
        var frame = $(this);
        if (!frame.hasClass('active')) {
            $(this).addClass('highlight bg-highlight');
            show_info(gettext('Kliknij, aby wyświetlić przykłady dla tej ramy oraz jej realizacje składniowe.'));
        }
    }).mouseleave(function() {
        $(this).removeClass('highlight bg-highlight');
        clear_info();
    }).click(function() {
        var frame = $(this);
        if (!frame.hasClass('active')) {
            select_frame(frame);
        }
        clear_info();
    });
    
    /*$('.plwn-url').click(function() {
        $(this).tooltip('hide');
    });*/
    
    // this would work nice, but the browser shows the url in the same place on link hover... :)
    /*$('.lu-plwn').mouseenter(function() {
        show_info(gettext('Przejdź do strony tej jednostki w <i>Słowosieci</i>.'));
    }).mouseleave(function() {
        clear_info();
    });
    $('.synset-plwn').mouseenter(function() {
        show_info(gettext('Przejdź do strony tego synsetu w <i>Słowosieci</i>.'));
    }).mouseleave(function() {
        clear_info();
    });*/
    
    $('.lu-plwn, .synset-plwn').click(function(event) {
        // don’t make link click select the frame
        event.stopPropagation();
    });
    
    // if there’s one frame, select it immediately
    if ($('.frame').length === 1) {
        select_frame($('.frame').first());
    }
    
    // if there’s no frames, disable the tab
    if ($('.frame').length === 0) {
        $('#semantics-tab').addClass('disabled');
    } else {
        $('#semantics-tab').removeClass('disabled');
    }
}

function clear_curr_example(semantics) {
    var selector = $(semantics ? '#semantics' : '#syntax');
    selector.find('.example.active').removeClass('active table-primary');
    selector.find('.phrase').removeClass('example-yes example-no');
    if (semantics) {
        selector.find('.argument').removeClass('example-yes example-no');
        $('#semantics-schemata').find('.schema').each(function() {
            if (!$(this).hasClass('inactive')) {
                $(this).show();
            }  
        });
    }
}

function restrict_semantics_examples() {
    $('#semantics-examples').show();
    $('#semantics-no-examples').hide();
    $('#semantics-examples-list').find('.example').show();
    var schema_id = $('#semantics-schemata').find('.schema.active').data('schema_id');
    //var argument_id = $('.argument.active').data('argument_id');
    var argument_ids = [];
    $('.argument.active').each(function() {
        argument_ids.push($(this).data('argument_id'));
    });
    var lu_id = $('.entry-meaning.active').data('lu_id');
    if (!(schema_id || argument_ids.length || lu_id)) {
        return;
    }
    var visible_examples = 0;
    $('#semantics-examples-list').find('.example').each(function() {
        var example = curr_examples_by_id[$(this).data('example_id')];
        if (
                //(argument_id && !example.argument_ids.includes(argument_id))
                (argument_ids.length && !argument_ids.every(elem => example.argument_ids.includes(elem)))
                ||
                (lu_id && !example.lu_ids.includes(lu_id))
                ||
                (schema_id && !example.schema_ids.includes(schema_id))
            ) {
            $(this).hide();
            if ($(this).hasClass('active')) {
                clear_curr_example(true);
            }
        } else {
            visible_examples += 1;
        }
    });
    if (visible_examples === 0) {
        $('#semantics-examples').hide();
        $('#semantics-no-examples').show();
    }
}

function bind_lus_click(frame) {
    frame.find('.entry-meaning').mouseenter(function() {
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć ograniczenie wyświetlanych przykładów do powiązanych z') + ' ' + gettext('tym znaczeniem') + '.');
        } else {
            show_info(gettext('Kliknij, aby wyświetlić wyłącznie przykłady powiązane z') + ' ' + gettext('tym znaczeniem') + '.');
        }
        $(this).addClass('bg-highlight');
    }).mouseleave(function() {
        $(this).removeClass('bg-highlight');
        clear_info();
    }).click(function(event) {
        // no need to propagate to frame
        event.stopPropagation();
        var active = $(this).hasClass('active');
        $('.entry-meaning.active').removeClass('active');
        $('#examples-lu').empty();
        if (!active) {
            var lu_id = $(this).data('lu_id');
            $(this).addClass('active');
            $('#examples-lu').html(' ' + $(this).html() + '');
        }
        // other restrictions might be active
        restrict_semantics_examples();
        clear_info();
    });
}

function unbind_lus_click(frame) {
    unbind_click(frame.find('.entry-meaning'));
}

function do_bind_arguments_click(selector) {
    selector.mouseenter(function() {
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć ograniczenie wyświetlanych przykładów do powiązanych z') + ' ' + gettext('tą rolą') + '.');
        } else {
            show_info(gettext('Kliknij, aby wyświetlić wyłącznie przykłady powiązane z') + ' ' + gettext('tą rolą') + '.');
        }
        $('.preferences[data-argument_id="' + $(this).data('argument_id') + '"]').addClass('bg-highlight');
    }).mouseleave(function() {
        $('.preferences[data-argument_id="' + $(this).data('argument_id') + '"]').removeClass('bg-highlight');
        clear_info();
    }).click(function(event) {
        // no need to propagate to frame
        event.stopPropagation();
        var active = $(this).hasClass('active');
        var argument_id = $(this).data('argument_id');
        var argument_element = $('.argument[data-argument_id="' + argument_id + '"]');
        var argument_role = argument_element.data('role');
        //$('.argument.active').removeClass('active');
        //$('.preferences.active').removeClass('active');
        //$('#examples-argument').empty();
        if (active) {
            argument_element.removeClass('active');
            $('.preferences[data-argument_id="' + argument_id + '"]').removeClass('active');
            $('.example-role[data-argument_id="' + argument_id + '"]').remove();
        } else {
            argument_element.addClass('active');
            $('.preferences[data-argument_id="' + argument_id + '"]').addClass('active');
            $('#examples-argument').append('<span class="example-role" data-argument_id="' + argument_id + '"> <span class="' + argument_role + '">' + argument_element.html() + '</span></span>');
        }
        // other restrictions might be active
        restrict_semantics_examples();
        clear_info();
    });
}

function bind_arguments_click(frame) {
    do_bind_arguments_click(frame.find('.argument'));
    //do_bind_arguments_click(frame.find('.preferences'));
}

function unbind_arguments_click(frame) {
    unbind_click(frame.find('.argument'));
    //unbind_click(frame.find('.preferences'));
}

function bind_semantics_schemata_click() {
    $('#semantics-schemata').find('.schema').mouseenter(function() {
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć ograniczenie wyświetlanych przykładów do powiązanych z') + ' ' + gettext('tym schematem') + '.');
        } else {
            show_info(gettext('Kliknij, aby wyświetlić wyłącznie przykłady powiązane z') + ' ' + gettext('tym schematem') + '.');
        }
        $(this).addClass('bg-highlight');
    }).mouseleave(function() {
        $(this).removeClass('bg-highlight');
        clear_info();
    }).click(function() {
        var active = $(this).hasClass('active');
        $('#semantics-schemata').find('.schema.active').removeClass('active');
        $('#semantics-examples-list').find('.example').show();
        $('#examples-schema').empty();
        if (!active) {
            $(this).addClass('active');
            $('#examples-schema').html(' [' + 'SCHEMAT' + ']');
        }
        // other restrictions might be active
        restrict_semantics_examples();
        clear_info();
    });
}

function unbind_semantics_schemata_click() {
    unbind_click($('#semantics-schema').find('.schema'));
}

function bind_frame_opinion_click(frame) {
    frame.find('.opinion-row').mouseenter(function(event) {
        event.stopPropagation();
        show_info(gettext('Kliknij, aby cofnąć wybór tej ramy.'));
        $(this).addClass('bg-highlight');
    }).mouseleave(function(event) {
        // propagate to change frame bg on mouseleave
        $(this).removeClass('bg-highlight');
    }).click(function(event) {
        // propagation would cause the frame to be selected
        event.stopPropagation();
        unselect_frame(frame);
    });
}

function unbind_frame_opinion_click(frame) {
    unbind_click(frame.find('.opinion-row'));
}

function select_frame(frame) {
    if ($('.frame.active').length > 0) {
        unselect_frame($('.frame.active'));
    }
    frame.removeClass('bg-highlight');
    frame.addClass('active');
    show_alternations(frame);
    show_semantics_examples(frame);
    bind_arguments_click(frame);
    bind_lus_click(frame);
    bind_frame_opinion_click(frame);
    bind_semantics_schemata_click();
}

function unselect_frame(frame) {
    unbind_arguments_click(frame);
    unbind_lus_click(frame);
    unbind_frame_opinion_click(frame);
    unbind_semantics_schemata_click();
    frame.removeClass('active');
    frame.find('.opinion-row').removeClass('bg-highlight');
    $('.argument.active').removeClass('active');
    $('.entry-meaning.active').removeClass('active');
    $('.preferences.active').removeClass('active');
    $('#semantics-schemata').find('.schema').removeClass('active');
    $('.extra-phrase-types').remove();
    $('.phrase').removeClass('initiator stimulus condition factor experiencer theme recipient result instrument manner purpose attribute location path time duration measure lemma source foreground background goal');
    $('.realisation-description').remove();
    $('.realisation-phrase').remove();
    clear_curr_example(true);
    $('#examples-argument').empty();
    $('#examples-lu').empty();
    $('#examples-schema').empty();
    $('#semantics-examples-list').empty();
    $('#semantics-examples').hide();
    $('#semantics-schemata').find('.schema').addClass('inactive');
    $('#semantics-schemata').find('.schema').show();
    $('#semantics-schemata').find('.subentry').show();
}

function show_alternations(frame) {
    var frame_id = frame.data('frame_id');
    for (var schema_id in curr_alternations[frame_id]) {
        var schema = $('#semantics-schemata').find('.schema[data-schema_id="' + schema_id + '"]')
        schema.removeClass('inactive');
        var phrase_row = schema.find('.phrase-types');
        var colspan = parseInt(schema.find('.opinion-cell').attr('colspan')) + 1;
        for (var i = 1; i < curr_alternations[frame_id][schema_id].length; i++) {
            var extra_phrase_row = phrase_row.clone();
            extra_phrase_row.removeClass('alt-0');
            extra_phrase_row.addClass('extra-phrase-types alt-' + (i));
            extra_phrase_row.find('.phrase').attr('data-alternation', i);
            schema.find('tbody').append(extra_phrase_row);
        }
        for (var i in curr_alternations[frame_id][schema_id]) {
            var alternation = curr_alternations[frame_id][schema_id][i];
            var row = schema.find('.phrase-types.alt-' + i);
            for (var arg_id in alternation) {
                var role = $('.argument[data-argument_id="' + arg_id + '"').data('role');
                for (var j in alternation[arg_id]) {
                    var phrase_id = alternation[arg_id][j];
                    row.find('.phrase[data-phrase_id="' + phrase_id + '"').addClass(role).after('<div class="realisation-phrase px-1 py-2"><i>' + curr_realisation_phrases[arg_id][i][phrase_id] + '</i></div>');
                }
            }
            var description_row = '<tr class="realisation-description"><td class="px-1 py-2" colspan="' + colspan + '"><i>' + curr_realisation_descriptions[frame_id][schema_id][i] + '</i></td></tr>';
            row.before(description_row);
        }
    }
    $('#semantics-schemata').find('.schema.inactive').hide();
    // hide subentries where all schemata are hidden
    $('#semantics-schemata').find('.subentry').each(function() {
        if ($(this).find('.schema').not('.inactive').length == 0) {
            $(this).hide();
        } else {
            $(this).show();
        }
    });
    if (get_show_reals_desc()) {
        show_reals_desc();
    } else {
        hide_reals_desc();
    }
}

function example_row(example) {
    var example_content = example.sentence;
    if (example.note) {
        example_content += ' ' + tooltipped_info(gettext('Komentarz') + ': <i>' + example.note + '</i>');
    }
    return '<tr class="example" data-example_id="' + example.id + '"><td class="py-1">' + example_content + '</td><td class="py-1">' + example.source + '</td><td class="py-1">' + example.opinion + '</td></tr>';
}

function show_syntax_examples(schema) {
    var schema_id = schema.data('schema_id');
    $('#syntax-examples-list').empty();
    for (var i in curr_examples) {
        var example = curr_examples[i];
        if (example.schema_ids.includes(schema_id)) {
            $('#syntax-examples-list').append(example_row(example));
        }
    }
    activate_tooltips($('#syntax-examples-list'));
    $('#syntax-examples-list').find('.example').mouseenter(function() {
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć wyświetlanie typów fraz powiązanych z tym przykładem.'));
        } else {
            show_info(gettext('Kliknij, aby wyświetlić typy fraz powiązane z tym przykładem.'));
        }
    }).mouseleave(function() {
        clear_info();
    }).click(function() {
        var active = $(this).hasClass('active');
        clear_curr_example(false);
        if (active) {
            return;
        }
        $(this).addClass('active table-primary');
        var example = curr_examples_by_id[$(this).data('example_id')];
        schema.find('.phrase').each(function() {
            if (example.phrases_syntax.includes($(this).data('phrase_id'))) {
                $(this).addClass('example-yes');
            } else {
                $(this).addClass('example-no');
            }
        });
        clear_info();
    });
    if ($('#syntax-examples-list').children().length > 0) {
        $('#syntax-examples').show();
        $('#syntax-no-examples').hide();
    }
}

function show_semantics_examples(frame) {
    var frame_id = frame.data('frame_id');
    $('#semantics-examples-list').empty();
    for (var i in curr_examples) {
        var example = curr_examples[i];
        if (example.frame_ids.includes(frame_id)) {
            $('#semantics-examples-list').append(example_row(example));
        }
    }
    activate_tooltips($('#semantics-examples-list'));
    $('#semantics-examples-list').find('.example').mouseenter(function() {
        if ($(this).hasClass('active')) {
            show_info(gettext('Kliknij, aby cofnąć wyświetlanie argumentów i typów fraz powiązanych z tym przykładem.'));
        } else {
            show_info(gettext('Kliknij, aby wyświetlić argumenty i typy fraz powiązane z tym przykładem.'));
        }
    }).mouseleave(function() {
        clear_info();
    }).click(function() {
        var active = $(this).hasClass('active');
        clear_curr_example(true);
        if (active) {
            return;
        }
        $(this).addClass('active table-primary');
        var example = curr_examples_by_id[$(this).data('example_id')];
        frame.find('.argument').each(function() {
            if (example.argument_ids.includes($(this).data('argument_id'))) {
                $(this).addClass('example-yes');
            } else {
                $(this).addClass('example-no');
            }
        });
        $('#semantics-schemata').find('.phrase').each(function() {
            if (example.phrases.includes($(this).data('phrase_id') + '-' + $(this).data('alternation'))) {
                $(this).addClass('example-yes');
            } else {
                $(this).addClass('example-no');
            }
        });
        $('#semantics-schemata').find('.schema').each(function() {
            if (!$(this).hasClass('inactive') && $(this).find('.example-yes').length === 0) {
                $(this).hide();
            }  
        });
        clear_info();
    });
    if ($('#semantics-examples-list').children().length > 0) {
        $('#semantics-examples').show();
        $('#semantics-no-examples').hide();
    }
}

function show_unmatched_examples() {
    $('#unmatched-examples-list').empty();
    for (var i in curr_examples) {
        var example = curr_examples[i];
        if (example.schema_ids.length === 0) {
            var example_content = example.sentence;
            if (example.note) {
                example_content += ' ' + tooltipped_info(gettext('Komentarz') + ': <i>' + example.note + '</i>');
            }
            $('#unmatched-examples-list').append('<tr class="example" data-example_id="' + example.id + '"><td class="py-1">' + example_content + '</td><td class="py-1">' + example.source + '</td><td class="py-1">' + example.opinion + '</td></tr>');
        }
    }
    activate_tooltips($('#unmatched-examples-list'));
    if ($('#unmatched-examples-list').children().length > 0) {
        $('#unmatched-examples').show();
        $('#unmatched-no-examples').hide();
        $('#examples-tab').removeClass('disabled');
    } else {
        $('#unmatched-examples').hide();
        $('#unmatched-no-examples').show();
        $('#examples-tab').addClass('disabled');
    }
}

function get_entry(entry_id, related) {
    check_import_status();
    clear_entry();
    show_entry_spinners();
    //var data = { 'forms' : serialize_forms($('#main-form')), 'entry' : entry_id };
    var data = { 'entry' : entry_id, 'no_filters' : related };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/entries/get_entry/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            curr_entry = entry_id;
            clear_info();
            curr_alternations = response.alternations;
            curr_realisation_phrases = response.realisation_phrases;
            curr_realisation_descriptions = response.realisation_descriptions;
            curr_examples = response.examples;
            curr_examples_by_id = Object();
            for (var i in curr_examples) {
                curr_examples_by_id[curr_examples[i].id] = curr_examples[i];
            }
            show_syntax(response.subentries);
            show_semantics(response.frames, response.subentries);
            show_unmatched_examples();
            
            // if current tab is empty, switch to an active tab
            var active_tab = $('#entryTabs').find('.nav-link.active').attr('id');
            if (active_tab === 'semantics-tab' && $('.frame').length === 0) {
                // current tab is semantics -> show syntax
                $('#syntax-tab').tab('show');
            } else if (active_tab === 'examples-tab') {
                if ($('.frame').length > 0) {
                    // current tab is examples, semantics nonempty -> show semantics
                    $('#semantics-tab').tab('show');
                } else {
                    // current tab is examples, semantics empty -> show syntax
                    $('#syntax-tab').tab('show');
                }
            }
            
            // tooltips with meaning gloss
            activate_tooltips($('.frame'));
            // tooltips with phrase descriptions
            activate_tooltips($('.schema'));
            update_last_visited(response.last_visited);
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function bind_last_visited() {
    $('.last-visited').click(function() {
        var selected_entry = $(this).data('entry');
        if (selected_entry !== curr_entry) {
            $('.entry[data-entry="' + curr_entry + '"]').removeClass('table-primary');
            get_entry(selected_entry);
        }
    });
}

function update_last_visited(last_visited) {
    var lv = $('#last-visited-dropdown');
    lv.empty();
    for (var i in last_visited) {
        if (i > 0) {
            lv.append('<a class="dropdown-item font-weight-bold text-dark text-uppercase last-visited" data-entry="' + last_visited[i][1] + '" href="#">' + last_visited[i][0] + '</a>');
        }
    }
    bind_last_visited();
}

function bind_settings() {
    activate_tooltips($('#page-nav'));
    $('#show-realisation-descriptions').change(function() {
        var val = $(this).prop('checked') === true;
        $.ajax({
            type     : 'post',
            url      : '/' + lang + '/entries/change_show_reals_desc/',
            dataType : 'json',
            data     : {'val' : val},
            success  : function(response) {
                if (val) {
                    show_reals_desc();
                } else {
                    hide_reals_desc();
                }
            },
            error: function(request, errorType, errorMessage) {
                show_error(errorType + ' (' + errorMessage + ')');
            }
        });
    });
    $('#show-linked-entries').change(function() {
        var val = $(this).prop('checked') === true;
        $.ajax({
            type     : 'post',
            url      : '/' + lang + '/entries/change_show_linked_entries/',
            dataType : 'json',
            data     : {'val' : val},
            success  : function(response) {
                update_entries();
            },
            error: function(request, errorType, errorMessage) {
                show_error(errorType + ' (' + errorMessage + ')');
            }
        });
    });
}

function show_reals_desc() {
    $('.realisation-description').show();
    $('.realisation-phrase').show();
}

function hide_reals_desc() {
    $('.realisation-description').hide();
    $('.realisation-phrase').hide();
}

function get_show_reals_desc() {
    return $('#show-realisation-descriptions').prop('checked') === true;
}

function update_entries() {
    
    $('#entries-table').DataTable({
        // https://datatables.net/manual/tech-notes/3
        destroy: true,
        //paging: false,
        // load on scroll, requires paging set to true (default)
        scroller: true,
        paging: true,
        scrollY: $('#entries-list-div').height() - $('#entries-table_filter').outerHeight() - $('.dataTables_scrollHead').outerHeight() - $('#entries-table_info').outerHeight(),
        serverSide: true,
        ajax: {
            url: '/' + lang + '/entries/get_entries/',
            type: 'POST',
        },
        // https://datatables.net/reference/option/dom
        dom: 'ftri',
        columns: [
            { data: 'lemma' },
            { data: 'status' },
            { data: 'POS' },
        ],
        orderMulti: false,
        // show processing indicator when sorting etc.
        processing: true,
        //searchDelay: 1000,
        // make the first (lemma) column cells <th> elements and set their scope
        columnDefs: [
            {
                targets: 0,
                cellType: "th",
                createdCell: function(td, cellData, rowData, row, col) {
                    $(td).prop('scope', 'row');
                }
            },
            {
                className: 'p-1',
                targets: [0, 1, 2],
            },
            // make only the lemma searchable
            {
                searchable: false,
                targets: [1, 2]
             }
        ],
        createdRow: function(row, data, dataIndex, cells) {
            $(row).addClass('entry');
            $(row).attr('data-entry', data.id);
            var related = data.related === true;
            if (related) {
                $(row).addClass('text-muted');
            }
            $(row).click(function() {
                var selected_entry = $(this).data('entry');
                if (selected_entry !== curr_entry) {
                    get_entry(selected_entry, related);
                    $('.entry[data-entry="' + curr_entry + '"]').removeClass('table-primary');
                    $(this).addClass('table-primary');
                }
            });
        },
        initComplete: function(settings, json) {
            // display the first entry once it’s loaded
            $('.entry').first().click();
        },
        language: {
            thousands:    lang === 'pl' ? ' ' : ',',
            processing:   gettext('Przetwarzanie...'),
            search:       gettext('Szukaj:'),
            info:         gettext('Liczba haseł: _TOTAL_'),
            infoEmpty:    gettext('Liczba haseł: 0'),
            infoFiltered: gettext('(spośród _MAX_)'),
            zeroRecords:  gettext('Brak haseł do wyświetlenia.'),
            aria: {
                sortAscending:  gettext(': sortuj kolumnę rosnąco'),
                sortDescending: gettext(': sortuj kolumnę malejąco'),
            }
        }
    });
    
    curr_entry = null;
}

function clear_results() {
    $('#entries').empty();
    clear_entry();
}

function clear_entry() {
    $('#syntax-schemata').empty();
    $('#syntax-examples-list').empty();
    $('#syntax-examples').hide();
    $('#syntax-no-examples').hide();
    
    $('#semantics-frames').empty();
    $('#semantics-schemata').empty();
    $('#examples-argument').empty();
    $('#examples-lu').empty();
    $('#examples-schema').empty();
    $('#semantics-examples-list').empty();
    $('#semantics-examples').hide();
    $('#semantics-no-examples').hide();
    
    $('#unmatched-examples-list').empty();
    $('#unmatched-examples').hide();
    $('#unmatched-no-examples').hide();
}

function adjust_heights() {
    // TODO using css() here makes the table info disappear, strange!!!
    $('#entries-list-div').attr('style', 'max-height: ' + ($('#entries-list').height() - $('#filter-div').outerHeight()) + 'px;');
    $('#entryTabsContent').css('max-height', ($('#entry-display').height() - $('#entryTabs').outerHeight()) + 'px');
    var h = $('#entries-list-div').height() - $('#entries-table_filter').outerHeight() - $('.dataTables_scrollHead').outerHeight() - $('#entries-table_info').outerHeight();
    $('.dataTables_scrollBody').height(h).css('max-height', h + 'px');
}

function initialize_entries_list() {
    
    $('#entries-table').DataTable({
        paging: false,
        scrollY: 300,
        data: [],
        // https://datatables.net/reference/option/dom
        dom: 'ftri',
        language: {
            search:       gettext('Szukaj:'),
            infoEmpty:    gettext('Liczba haseł: 0'),
            zeroRecords:  gettext('Brak haseł do wyświetlenia.'),
            aria: {
                sortAscending:  gettext(': sortuj kolumnę rosnąco'),
                sortDescending: gettext(': sortuj kolumnę malejąco')
            }
        }
    });
    
}



$(document).ready(function() {

    Split(['#entries-list', '#entry-display'], {
        sizes: [20, 80],
        minSize: 300,
        gutterSize: 4,
        elementStyle: (dimension, size, gutterSize) => {
            return {
                'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
            }
        },
    });
    
    Split(['#semantics-top-pane', '#semantics-examples-pane'], {
        direction: 'vertical',
        sizes: [75, 25],
        gutterSize: 4,
    });
    
    Split(['#semantics-frames-pane', '#semantics-schemata-pane'], {
        sizes: [40, 60],
        minSize: 400,
        gutterSize: 4,
        elementStyle: (dimension, size, gutterSize) => {
            return {
                'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
            }
        },
    });
    
    Split(['#syntax-schemata-pane', '#syntax-examples-pane'], {
        direction: 'vertical',
        sizes: [75, 25],
        gutterSize: 4,
    });
    
    adjust_heights();
    
    $(window).resize(adjust_heights);
    
    bind_last_visited();
    
    bind_settings();
    
    initialize_entries_list();
    
    $('#id_filter_schema_').change(function() {
        get_entry(curr_entry);
    });
    
    $('#id_filter_frame_').change(function() {
        get_entry(curr_entry);
    });
    
    initialize_main_form();
    
    initialize_frames_form();
    
    initialize_schemata_form();
    
    //$('.local-filter').hide();
    
    $('#main-form').submit();
    
});
