#! /usr/bin/python
# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand

import os, logging
from xml.sax import handler, make_parser

from django.db.models import Max

from importer.unification.UnificationPreprocessXML import UnificationPreprocessHandler
from shellvalier.settings import BASE_DIR
from common.models import ImportInProgress
from django.db import connection

from unifier.models import UnifiedFrameArgument


class Command(BaseCommand):
    args = 'none'
    help = ''

    def handle(self, **options):
        import_unification()

def import_unification():

    logging.basicConfig(filename='import_unification.log', level=logging.DEBUG)

    xml_file = os.path.join(BASE_DIR, 'data', 'unification', 'unify_example_small.xml')

    xml_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), xml_file)

    parser = make_parser()
    parser.setFeature(handler.feature_external_ges, False)

    parser.setContentHandler(UnificationPreprocessHandler())
    parser.parse(xml_path)

    max_id = UnifiedFrameArgument.objects.aggregate(Max('id'))['id__max']+1

    trigger_sql = "ALTER SEQUENCE unifier_unifiedframeargument_id_seq RESTART "+str(max_id)+";"
    cursor = connection.cursor()
    cursor.execute(trigger_sql)

    ImportInProgress.objects.all().delete()
