import datetime

from collections import defaultdict
from itertools import chain

from django.http import JsonResponse
from django.shortcuts import render

from connections.models import Entry, Subentry, ArgumentConnection
from syntax.models import Schema
from semantics.models import Frame

#from .forms import FiltersForm
#from .polish_strings import SCHEMA_OPINION, FRAME_OPINION

'''
def filters_test(request):
    return render(request, 'filters_test.html', { 'filters_form' : FiltersForm() })

def filter_objects(objects, queries):
    print('===================================================================')
    for query in queries:
        print('***', query)
        objects = objects.filter(query).distinct()
        print('---------------------------------------------------------------')
        print(objects)
        print('\n')
    print('===================================================================')
    return objects.distinct()

# TODO a more efficient loading of results will be implemented,
# for now truncate them to speed up testing 
DEBUG_N = 100
def get_entries(request):
    t1 = datetime.datetime.now()
    if request.method == 'GET':
        form = FiltersForm(request.GET)
        if not form.is_valid():
            print(form.errors)
            return JsonResponse({ 'result' : [], 'errors' : form.errors })
        if form.is_valid():
            queries = form.get_queries()
            t2 = datetime.datetime.now()
            entries = filter_objects(Entry.objects.all(), queries)
            # TODO remove! – this is for debug
            entries = entries.filter(pos__tag='verb').filter(subentries__schemata__positions__phrases_count__gte=3)
            t3 = datetime.datetime.now()
            #entries_list = [(e.id, e.name, e.status.key) for e in entries]#[:500]]
            entries_list = list(entries.values_list('id', 'name', 'status__key'))[:DEBUG_N]
            t4 = datetime.datetime.now()
            s = ' truncated to {}'.format(DEBUG_N) if len(entries_list) == DEBUG_N else ''
            debug = '[{} s] [{} results{}] '.format(t2, entries.count(), s)
            debug += '[filtering: {:.1} s] '.format((t2 - t1).total_seconds())
            debug += '[processing: {:.1} s] '.format((t4 - t3).total_seconds())
            debug += '[total time: {:.1} s] '.format((t4 - t1).total_seconds())
            return JsonResponse({ 'result' : entries_list, 'debug' : debug })
    return JsonResponse({})

def subentry2str(subentry):
    ret = subentry.entry.name
    if subentry.inherent_sie.name == 'true':
        ret += ' się'
    elems = []
    if subentry.aspect:
        elems.append(subentry.aspect.name)
    if subentry.negativity:
        elems.append(subentry.negativity.name)
    if elems:
        ret += ' ({})'.format(', '.join(elems))
    if subentry.predicativity.name == 'true':
        ret += ' pred.'
    return ret

def schema2dict(schema, phr2arg):
    return {
        'opinion'   : SCHEMA_OPINION[schema.opinion.key],
        'id'        : str(schema.id),
        'positions' : [
            {
                'func'    : p.function.name if p.function else '',
                'phrases' : [
                    {
                        'str'       : str(pt),
                        'id'        : '-'.join(map(str, (schema.id, p.id, pt.id))),
                        'arguments' : list(phr2arg['-'.join(map(str, (schema.id, p.id, pt.id)))]),
                    } for pt in p.phrase_types.all()
                ],
            } for p in schema.positions.all()
         ],
    }

def get_prefs_list(argument):
    prefs = [argument.predefined.all(), argument.synsets.all(), argument.relations.all()]
    return list(chain(*map(list, prefs)))

def frame2dict(frame, arg2phr):
    return {
        'opinion'   : FRAME_OPINION[frame.opinion.key],
        'id'        : str(frame.id),
        'arguments' : [
            {
                'str'         : str(a),
                'id'          : '-'.join(map(str, (frame.id, a.id))),
                'preferences' : list(map(str, get_prefs_list(a))),
                'phrases'     : list(arg2phr['-'.join(map(str, (frame.id, a.id)))]),
            } for a in frame.argument_set.all()
         ],
    }

def get_entry(request):
    if request.method == 'GET':
        form = FiltersForm(request.GET)
        eid = request.GET['entry']
        if eid.isdigit() and form.is_valid():
            eid = int(eid)
            entry = Entry.objects.get(id=eid)
            #===================================================================
            phr2arg, arg2phr = defaultdict(set), defaultdict(set)
            connections = ArgumentConnection.objects.filter(schema_connections__subentry__entry=entry)
            for conn in connections:
                arg = '-'.join(map(str, (conn.argument.frame.id, conn.argument.id)))
                for hook in conn.schema_connections.all():
                    phr = '-'.join(map(str, (hook.schema.id, hook.position.id, hook.phrase_type.id)))
                    phr2arg[phr].add(arg)
                    arg2phr[arg].add(phr)
            #===================================================================
            schema_queries = []
            if form.cleaned_data['filter_schema_']:
                schema_queries = form.get_queries('schema')
            frame_queries = []
            if form.cleaned_data['filter_frame_']:
                frame_queries = form.get_queries('frame')
            subentries = []
            for subentry in entry.subentries.all():
                schemata = []
                for schema in filter_objects(subentry.schemata.all(), schema_queries):
                    schemata.append(schema2dict(schema, phr2arg))
                if schemata:
                    subentries.append({ 'str' : subentry2str(subentry), 'schemata' : schemata })
            frame_objs = Frame.objects.filter(argument__argument_connections__schema_connections__subentry__entry=entry)
            frames = [frame2dict(frame, arg2phr) for frame in filter_objects(frame_objs, frame_queries)]
            return JsonResponse({ 'subentries' : subentries, 'frames' : frames })
    return JsonResponse({})
'''
