function update_entries() {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (data) {
        return (
            data
            && data.assignee_username === window.USER_USERNAME
        ) ? gettext("tak") : gettext("nie");
    }

    var datatable = setup_datatable({
        url: '/' + lang + '/unifier/get_unified_frames/',
        columns: [
            { data: 'title' },
            { data: 'status' },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
            { data: 'id' },
        ],
        hidden_columns: [3]
    });
    datatable.on('click', 'tr.entry', function () {
        var selected_entry = $(this).data('entry');
        var data = datatable.row(this).data();
        if (!data) return;
        var related = data.related === true;
        if (selected_entry !== curr_entry) {
            $('.entry[data-entry="' + curr_entry + '"]').removeClass('table-primary');
            //TODO: zastapic etoda pobierajaca rame za po jej id
            get_unified_frame(data.id)
            // get_entry(selected_entry, related);
            $(this).addClass('table-primary');
        }
    });
}
