import LexicalUnitDisplay from './LexicalUnitDisplay.js';
import LexicalUnitEdit from './LexicalUnitEdit.js';

export default {
  components: {LexicalUnitDisplay, LexicalUnitEdit},
  props: {
    entryId: Number,
    lexicalUnitId: Number,
  },
  data () {
    return this.getInitialData();
  },
  methods: {
    getInitialData () {
      return {
        isEdit: false,
        key: this.lexicalUnitId,
        unifiedFrameId: null
      };
    },
    goToEdit (unifiedFrameId) {
      this.isEdit = true;
      this.unifiedFrameId = unifiedFrameId;
    },
    goToDisplay () {
      this.isEdit = false;
      this.unifiedFrameId = null;
    },
    refresh () {
      this.key = null;
      setTimeout(() => { this.key = this.lexicalUnitId; }, 0);
      update_entries();
    }
  },
  watch: {
    lexicalUnitId () {
      Object.assign(this, this.getInitialData());
    }
  },
  template: `
    <div v-if="key" :key="key" class="row m-0 p-0 overflow-auto" id="semantics-top-pane">
      <lexical-unit-display
        v-if="lexicalUnitId && !isEdit"
        :entryId="entryId"
        :lexicalUnitId="lexicalUnitId"
        @go-to-edit="goToEdit"
        @refresh="refresh"
      />
      <lexical-unit-edit
        v-if="isEdit"
        :unifiedFrameId="unifiedFrameId"
        @go-to-display="goToDisplay"
      />
    </div>
  `
}
