import InfoTooltip from "./InfoTooltip.js";
import Spinner from "./Spinner.js";

export default {
  props: {
    unifiedFrameId: Number
  },
  data() {
    return {
      gettext: window.gettext,
      unified_frame: Object,
      unified_frame_arguments: [],
      active_unified_frame_argument: null,
      slowal_frames2selecional_preferencies_mapping: {},
      lexical_units: [],
      img_prefix: String,
      frames: []
    }
  },
  components: { InfoTooltip, Spinner },
  emits: ['goToDisplay', 'refresh'],
  watch: {
    unifiedFrameId: function () {
      this.loadFrame();
    }
  },
  methods: {
    async loadFrame() {
      try {
        var data = {'unified_frame_id': this.unifiedFrameId};
        $.ajax({
          type: 'post',
          url: '/' + lang + '/unifier/get_unified_frame/',
          dataType: 'json',
          data: data,
          timeout: 60000,
          success: function (response) {

            this.img_prefix = window.STATIC_URL;

            this.unified_frame = response.unified_frame;
            this.unified_frame_arguments = this.unified_frame.arguments;
            this.frames = response.frames;

            this.lexical_units = frames2lexical_units(response.frames);

            $('#lexical-unit').html(this.unified_frame.title || lexical_units2dom(this.lexical_units));

            this.slowal_frames2selecional_preferencies_mapping = slowal_frames2selecional_preferencies(this.unified_frame, response.frames);

            // unified_view_frame_content = response.frames
            curr_entry = this.unifiedFrameId;
            // curr_no_filters = related;
            clear_info();
            curr_alternations = response.alternations;
            curr_realisation_phrases = response.realisation_phrases;
            curr_realisation_descriptions = response.realisation_descriptions;
            curr_examples = response.examples;
            curr_examples_by_id = Object();
            for (var i in curr_examples) {
              curr_examples_by_id[curr_examples[i].id] = curr_examples[i];
            }
            // show_syntax(response.subentries);
            // show_unified_frame(response.unified_frame, response.frames)
            show_unified_frame_lexical_units(response.frames)
            fulfill_slowal_frames_arguments_with_empty_elems(response.unified_frame, response.frames)
            show_semantics_unified_view(response.frames, response.subentries);
            // show_unmatched_examples();

            // tooltips with meaning gloss
            activate_tooltips($('#semantics-frames-pane'));
            update_last_visited(response.last_visited);
          }.bind(this),
          error: function (request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
          }
        });

      } catch (error) {
        console.log(error);
      }
    },
    unifiedFrameArgumentSelected (argument) {
      if (this.active_unified_frame_argument === argument) {
        this.active_unified_frame_argument = null;
      } else {
        this.active_unified_frame_argument = argument;
      }
    },
    addSelectivePreference () {
      if (!this.active_unified_frame_argument) {
        alert(gettext("Zaznacz argument, do którego chcesz dodać preferencję."));
      } else {
        window.addSelectivePreference(this.unified_frame, this.active_unified_frame_argument.id, this.frames);
      }
    }
  },
  created() {
    this.loadFrame();
  },
  template: `
    <div class="col h-100 px-1 pt-0 pb-0 overflow-auto" id="semantics-frames-pane">
      <table class="table-button-menu" cellspacing="1">
        <tr style="background-color: white;">
          <td id="change-title" style="padding: 10px 15px 10px 15px; color: #000000;">Zmień nazwę</td>
          <td id="add-arg" style="padding: 10px 15px 10px 15px; color: #000000;">Dodaj argum.</td>
          <td style="padding: 10px 15px 10px 15px; color: #000000;" @click="addSelectivePreference">Dodaj prefer.</td>
          <td id="merge" style="padding: 10px 15px 10px 15px; color: #000000;">Scal</td>
          <td style="padding: 10px 15px 10px 15px; color: #000000;" @click="$emit('goToDisplay')">Gotowe</td>
        </tr>
        <tr style="background-color: white;">
          <td id="change-role" style="padding: 10px 15px 10px 15px; color: #000000;">Zmień rolę</td>
          <td id="remove-arg" style="padding: 10px 15px 10px 15px; color: #000000;">Usuń argum.</td>
          <td id="change-windows" style="padding: 10px 15px 10px 15px; color: #000000;">Zamień okna</td>
          <td id="duplicates" style="padding: 10px 15px 10px 15px; color: #000000;">Duplikuj</td>
          <td id="save-changes" style="padding: 10px 15px 10px 15px; color: #000000;">Zapisz</td>
        </tr>
      </table>
      <spinner />
      <div class="unifiedFrame mt-3" v-bind:data-frame_id="unified_frame.id" id="lexical-unit"></div>
      <table v-if="unified_frame.id" id="unified-frame" class="table m-0 table-borderless border border-secondary text-dark">
        <tbody>
          <tr>
            <th scope="row" class="py-2 px-1 text-secondary">Role</th>
            <td
              class="argument py-2 px-1 border-top border-left border-secondary role"
              :class="argument == active_unified_frame_argument && 'active'"
              v-for="argument in unified_frame_arguments"
              :key="argument.id"
              @click="unifiedFrameArgumentSelected(argument)"
            >
              {{ argument.role_type }}
              <ul>
                <li v-for="proposed_role in argument.proposed_roles">
                  {{ proposed_role.role }}
                </li>
              </ul>
            </td>
          </tr>
          <tr>
            <th scope="row" class="py-0 px-1 text-secondary">Selectional preferences</th>
            <td class="preferences py-0 px-0 border-top border-left border-secondary"
                v-for='argument in unified_frame_arguments'
                :key='argument.id'
            >
              <ul>
                <li v-for='preference in argument.preferences'>
                  <div
                    v-if="preference.url != null"
                    class="preference py-2 px-1 preference-bold"
                  >
                    <a class="synset-plwn" v-bind:href="preference.url" target="_blank">{{ preference.str }}</a>
                  </div>
                  <div v-else class="preference py-2 px-1 preference-bold">{{ preference.str }}</div>
                </li>
              </ul>
              <ul>
                <li v-for="preference in slowal_frames2selecional_preferencies_mapping[argument.id]">
                  <span v-if="preference.url != null" class="preference py-2 px-1">
                    <a class="synset-plwn" v-bind:href="preference.url" target="_blank">{{ preference.str }}</a>
                  </span>
                  <span v-else class="preference py-2 px-1">{{ preference.str }}</span>
                  <info-tooltip v-if="preference.info" :text="preference.info" />
                </li>
              </ul>
            </td>
          </tr>
        </tbody>
      </table>

      <div v-if="unified_frame.id" class="frame mt-3 mb-3">
        <table class="table m-0 table-borderless border border-secondary text-dark">
          <tbody>
            <tr>
              <th scope="row" class="py-2 px-1 text-secondary">Jednostka leksykalna</th>
              <th scope="row" class="py-2 px-1 text-secondary">Opinion</th>
            </tr>
            <tr class="preferences py-0 px-0 border-top border-left border-secondary"
              v-for='lexical_unit in lexical_units'
            >
              <td class="argument py-2 px-1 border-top border-left border-secondary">{{ lexical_unit.str }}</td>
              <td class="argument py-2 px-1 border-top border-left border-secondary">
                <img v-bind:src="img_prefix + 'entries/img/' +lexical_unit.opinion_key + '.svg'" width="12" height="12" v-bind:alt="lexical_unit.opinion">
                {{ lexical_unit.opinion }}
              </td>
            </tr>
          </tbody>
        </table>
      </div>

      <table v-if="unified_frame.id" class="table-button-menu" cellspacing="1">
        <tr style="background-color: white;">
          <td id="wrong-frame" style="padding: 10px 15px 10px 15px; color: #000000;">Błędna</td>
          <td
            style="padding: 10px 15px 10px 15px; color: #000000;"
            onclick="extract_frames_to_new_frame(1, [104274,104238], null)"
          >
            Rozdziel
          </td>
          <td id="hide-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;">Ukryj</td>
          <td id="ready-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;">Gotowe</td>
          <td id="filter-slowal-frames" style="padding: 10px 15px 10px 15px; color: #000000;">Filtruj</td>
        </tr>
        <tr style="background-color: white;">
          <td id="inccorect-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;">
              Niepasująca
          </td>
          <td id="move-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;"
              onclick="extract_frames_to_new_frame(3, [104274], 1)">
              Przerzuć
          </td>
          <td id="show-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;">
              Pokaż
          </td>
          <td id="reollback-slowal-frame" style="padding: 10px 15px 10px 15px; color: #000000;">
              Przywróć
          </td>
          <td id="empty" style="padding: 10px 15px 10px 15px; color: #000000;"></td>
        </tr>
      </table>
      <div id="semantics-frames"></div>
    </div>
    <div class="col h-100 px-1 pt-0 pb-0 overflow-auto" id="semantics-schemata-pane">
      <ul class="nav nav-pills nav-justified p-1" id="entryTabs" role="tablist">
        <li class="nav-item mr-1">
            <a class="btn btn-sm btn-outline-dark nav-link active" id="unified-frame-semantics-tab" data-toggle="tab" href="#semantics" role="tab" aria-controls="semantics" aria-selected="true">
                {{ gettext('Schematy') }}
            </a>
        </li>
        <li class="nav-item mr-1">
            <a class="btn btn-sm btn-outline-dark nav-link" id="unified-frame-view2-tab" data-toggle="tab" href="#syntax" role="tab" aria-controls="syntax" aria-selected="false">
                {{ gettext('Podgląd ram') }}
            </a>
        </li>
        <li class="nav-item mr-0">
            <a class="btn btn-sm btn-outline-dark nav-link" id="unified-frame-notes-tab" data-toggle="tab" href="#examples" role="tab" aria-controls="examples" aria-selected="false">
                {{ gettext('Notatki') }}
            </a>
        </li>
      </ul>
      <div id="semantics-schemata"></div>
    </div>
  `
}
