export default {
  props: { text: String },
  data () {
    return {
      iconUrl: window.STATIC_URL + 'common/img/info.svg'
    }
  },
  computed: {
    quotedText () {
      return this.text.replace(/"/g, '&quot;');
    }
  },
  created () {
    $("[data-toggle='tooltip']").tooltip();
  },
  template: `
    <span
      data-toggle="tooltip"
      data-placement="bottom"
      data-html="true"
      :title="quotedText"
    >
      <img :src="iconUrl" alt="info" width="14" height="14" />
    </span>
  `
}
