function update_entries() {
    var datatable = setup_datatable({
        element: $("#entries-table"),
        selectFirst: true,
        url: '/' + lang + '/entries/get_entries/',
        columns: [
            { data: 'lemma' },
            { data: 'status' },
            { data: 'POS' },
        ]
    });
    datatable.on('click', 'tr.entry', function () {
        var selected_entry = $(this).data('entry');
        var data = datatable.row(this).data();
        if (!data) return;
        var related = data.related === true;
        if (selected_entry !== curr_entry) {
            $('.entry[data-entry="' + curr_entry + '"]').removeClass('table-primary');
            get_entry(selected_entry, related);
            $(this).addClass('table-primary');
        }
    });
}
