export default {
  data () {
    return {
      gettext: window.gettext,
      canViewAssignment: has_permission("users.view_assignment")
    }
  },
  emits: ['unifiedFrameSelected'],
  mounted () {
    setup_entries_for_frames_list({
      table: this.$refs.table,
      lexicalUnitSelected: (lexicalUnitUnifiedFrameId) => { this.$emit('unifiedFrameSelected', lexicalUnitUnifiedFrameId); }
    });
  },
  template: `
    <table ref="table" class="table table-sm table-hover text-dark">
      <thead>
        <tr>
          <th class="p-1">{{ gettext('Lemat') }}</th>
          <th class="p-1">{{ gettext('Część mowy') }}</th>
          <th class="p-1">{{ gettext('Do pobrania') }}</th>
          <th v-if="canViewAssignment" class="p-1">{{ gettext('Semantyk') }}</th>
          <th v-else class="p-1">{{ gettext('Moje (w opracowaniu)') }}</th>
        </tr>
      </thead>
      <tbody id="entries">
      </tbody>
    </table>
  `
};
