import UnificationEntriesList from "./UnificationEntriesList.js";
import UnificationRightPane from "./UnificationRightPane.js";

export default {
  data () {
    return {
      entryId: null,
      lexicalUnitId: null,
      unifiedFrameId: null,
      isEdit: false,
      gettext: window.gettext,
    };
  },
  components: {UnificationEntriesList, UnificationRightPane},
  methods: {
    lexicalUnitSelected (entryId, lexicalUnitId) {
      this.entryId = entryId;
      this.lexicalUnitId = lexicalUnitId;
      this.isEdit = false;
    },
    unifiedFrameSelected (unifiedFrameId) {
      this.unifiedFrameId = unifiedFrameId;
      this.isEdit = true;
    }
  },
  mounted () {
    Split(['#right-pane', '#examples'], {
      direction: 'vertical',
      sizes: [75, 25],
      gutterSize: 4,
    });
  },
  template: `
    <div id="entries-list" class="col h-100 w-100 px-0">
      <div id="entries-list-div" class="col p-0 h-100 w-100 overflow-auto">
        <unification-entries-list @lexical-unit-selected="lexicalUnitSelected" />
      </div>
    </div>
    <div id="entry-display" class="col h-100 p-0">
      <div class="w-100 h-100">
        <div id="right-pane" class="col w-100 p-0">
          <unification-right-pane 
            :entryId="entryId" 
            :lexicalUnitId="lexicalUnitId" 
            :initialUnifiedFrameId="unifiedFrameId"
            :initialIsEdit="isEdit" />
        </div>
        <div class="col w-100 p-0 tab-pane overflow-auto" id="examples">
            <table id="semantics-examples" class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th scope="col">{{ gettext("Przykład") }}<i id="examples-argument"></i><i id="examples-lu"></i><i id="examples-schema"></i></th>
                        <th scope="col">{{ gettext("Źródło") }}</th>
                        <th scope="col">{{ gettext("Opinia") }}</th>
                    </tr>
                </thead>
                <tbody id="semantics-examples-list">
                </tbody>
            </table>
            <p class="mx-1 my-1" id="semantics-no-examples">{{ gettext("Brak przykładów") }}</p>
        </div>
      </div>
    </div>
  `
};
