#include <libwccl/ops/nor.h>

namespace Wccl {

Nor::BaseRetValPtr Nor::apply_internal(const SentenceContext &context) const
{
	foreach(BoolFunctionPtr expression, *expressions_) {
		if(expression->apply(context)->get_value()) {
			return Predicate::False->apply(context);
		}
	}
	return Predicate::True->apply(context);
}

const std::string Nor::raw_operator_name() const {
	return "not";
}

} /* end ns Wccl */
