#ifndef LIBWCCL_OPS_INTERSECTS_H
#define LIBWCCL_OPS_INTERSECTS_H

#include <boost/shared_ptr.hpp>

#include <libcorpus2/tagset.h>

#include <libwccl/values/strset.h>
#include <libwccl/values/tset.h>
#include <libwccl/values/bool.h>
#include <libwccl/ops/setpredicate.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

/**
 * Class that realises a predicate checking if one set intersects with another
 */
template <class T>
class Intersects : public SetPredicate<T>
{
public:
	typedef typename SetPredicate<T>::SetFunctionPtr SetFunctionPtr;

	Intersects(const SetFunctionPtr& set1_expr, const SetFunctionPtr& set2_expr)
		: SetPredicate<T>(set1_expr, set2_expr)
	{
	}

	virtual const std::string raw_operator_name() const {
		return "inter";
	}

protected:

	typedef typename SetPredicate<T>::BaseRetValPtr BaseRetValPtr;

	/**
	 * Take values for both sets and return True if they intersect,
	 * False otherwise.
	 */
	virtual BaseRetValPtr apply_internal(const SentenceContext& context) const {
		boost::shared_ptr<T> set1 = this->set1_expr_->apply(context);
		boost::shared_ptr<T> set2 = this->set2_expr_->apply(context);
		if(set1->is_subset_of(*set2)) {
			return Predicate::True->apply(context);
		}
		return Predicate::False->apply(context);
	}

};

} /* end ns Wccl */


#endif // LIBWCCL_OPS_INTERSECTS_H
