#include <libwccl/ops/and.h>

namespace Wccl {

And::BaseRetValPtr And::apply_internal(const SentenceContext &context) const
{
	foreach(boost::shared_ptr< Function<Bool> > expression, *expressions_) {
		if(!(expression->apply(context)->get_value())) {
			return Predicate::False->apply(context);
		}
	}
	return Predicate::True->apply(context);
}

const std::string And::raw_operator_name() const {
	return "and";
}

} /* end ns Wccl */
