#include <libwccl/ops/functions/bool/predicates/debug.h>
#include <libwccl/ops/formatters.h>

namespace Wccl {

DebugPrint::BaseRetValPtr DebugPrint::apply_internal(const FunExecContext& context) const
{
	const boost::shared_ptr<const Value>& v = expr_->apply_internal(context);
	std::cerr << v->to_raw_string() << "\n";
	return Predicate::True(context);
}

std::string DebugPrint::to_string(const Corpus2::Tagset& tagset) const
{
	return UnaryFunctionFormatter::to_string(tagset, *this, *expr_);
}

std::ostream& DebugPrint::write_to(std::ostream& os) const
{
	return os << raw_name() << "(" << *expr_ << ")";
}

} /* end ns Wccl */
