#include <libwccl/sentencecontext.h>
#include <libwccl/ops/match/applyoperator.h>
#include <libwccl/ops/matchrule.h>

#include <sstream>

namespace Wccl {

void MatchRule::apply(const boost::shared_ptr<Corpus2::AnnotatedSentence>& s)
{
	if(!s) {
		throw InvalidArgument("s", "Received a null sentence.");
	}
	if(s->size() == 0) {
		throw InvalidArgument("s", "Received an empty sentence.");
	}
	if (!apply_) {
		return; // no-op (default) version
	}
	apply_->execute(ActionExecContext(SentenceContext(s), variables_));
}

std::string MatchRule::to_string(const Corpus2::Tagset &tagset) const
{
	std::ostringstream os;
	os << apply_->to_string(tagset);
	return os.str();
}

std::ostream& MatchRule::write_to(std::ostream& os) const
{
	return os << *apply_;
}

} /* end ns Wccl */
