#include <libwccl/ops/match/matchoperator.h>
#include <sstream>

namespace Wccl {

boost::shared_ptr<Match> MatchOperator::apply(const ActionExecContext& context) const
{
	int orig_pos = context.sentence_context().get_position();
	MatchResult res = _conditions->apply(context);
	if(res.matched()) {
		return res.get_match();
	}
	context.sentence_context().set_position(orig_pos + 1);
	return boost::make_shared<Match>();
}

std::string MatchOperator::to_string(const Corpus2::Tagset& tagset) const
{
	std::ostringstream ostream;
	ostream << name() << _conditions->to_string(tagset);
	return ostream.str();
}

std::ostream& MatchOperator::write_to(std::ostream &ostream) const
{
	return ostream << name() << *_conditions;
}

} /* end ns Wccl */
