#ifndef LIBWCCL_OPS_MATCH_MATCHCONDITION_H
#define LIBWCCL_OPS_MATCH_MATCHCONDITION_H

#include <libwccl/ops/actionexeccontext.h>
#include <libwccl/ops/expression.h>
#include <libwccl/ops/match/matchresult.h>

namespace Wccl {

/**
 * Abstract base class for conditions of MatchOperator
 */
class MatchCondition : public Expression
{
public:
	/**
	 * @returns Name of the condition.
	 */
	virtual std::string name() const = 0;
	/**
	 * Applies the condition to the given execution context.
	 * If match is found, the current sentence position is
	 * set to position right after the match.
	 */
	virtual MatchResult apply(const ActionExecContext& context) const = 0;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_MATCHCONDITION_H
