#ifndef LIBWCCL_OPS_MATCH_ACTIONS_MARKMATCH_H
#define LIBWCCL_OPS_MATCH_ACTIONS_MARKMATCH_H

#include <libwccl/ops/match/matchaction.h>
#include <libwccl/ops/function.h>

namespace Wccl {

class MarkMatch : public MatchAction
{
public:
	MarkMatch(
			const boost::shared_ptr<Function<Match> >& match_from,
			const boost::shared_ptr<Function<Match> >& match_to,
			const boost::shared_ptr<Function<Match> >& head_match,
			const std::string& annotation_name)
		: match_from_(match_from),
		  match_to_(match_to),
		  head_match_(head_match),
		  chan_name_(annotation_name)
	{
		BOOST_ASSERT(match_from_);
		BOOST_ASSERT(match_to_);
		BOOST_ASSERT(head_match_);
	}

	MarkMatch(
			const boost::shared_ptr<Function<Match> >& match_from,
			const boost::shared_ptr<Function<Match> >& match_to,
			const std::string& annotation_name)
		: match_from_(match_from),
		  match_to_(match_to),
		  head_match_(match_from),
		  chan_name_(annotation_name)
	{
		BOOST_ASSERT(match_from_);
		BOOST_ASSERT(match_to_);
		BOOST_ASSERT(head_match_);
	}

	MarkMatch(
			const boost::shared_ptr<Function<Match> >& match_from_to,
			const std::string& annotation_name)
		: match_from_(match_from_to),
		  match_to_(match_from_to),
		  head_match_(match_from_to),
		  chan_name_(annotation_name)
	{
		BOOST_ASSERT(match_from_);
		BOOST_ASSERT(match_to_);
		BOOST_ASSERT(head_match_);
	}
	/**
	 * @returns Name of the action.
	 */
	std::string name() const {
		return "mark";
	}

	/**
	 * Executes the action for the given execution context.
	 */
	void execute(const ActionExecContext& context) const;

	/**
	 * @returns String representation of the expression.
	 */
	std::string to_string(const Corpus2::Tagset& tagset) const;

protected:
	/**
	 * Writes string representation of the MatchAction to
	 * an output stream.
	 * @returns Stream written to.
	 * @note May be incomplete and/or containt internal info.
	 */
	virtual std::ostream& write_to(std::ostream& ostream) const;
private:
	const boost::shared_ptr<Function<Match> > match_from_;
	const boost::shared_ptr<Function<Match> > match_to_;
	const boost::shared_ptr<Function<Match> > head_match_;
	const std::string chan_name_;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_MATCH_ACTIONS_MARKMATCH_H
