IF (PwrUtils_INCLUDE_DIR AND PwrUtils_LIBRARY)
#already in cache
   SET(PwrUtils_FOUND TRUE)
ELSE (PwrUtils_INCLUDE_DIR AND PwrUtils_LIBRARY)

   FIND_PATH(PwrUtils_INCLUDE_DIR libpwrutils/foreach.h /usr/include /usr/local/include )

   FIND_LIBRARY(PwrUtils_LIBRARY pwrutils /usr/lib /usr/local/lib) 

   MARK_AS_ADVANCED(PwrUtils_LIBRARY)
   MARK_AS_ADVANCED(PwrUtils_INCLUDE_DIR)

   IF (PwrUtils_INCLUDE_DIR AND PwrUtils_LIBRARY)
      SET(PwrUtils_FOUND TRUE)
   ENDIF (PwrUtils_INCLUDE_DIR AND PwrUtils_LIBRARY)
ENDIF (PwrUtils_INCLUDE_DIR AND PwrUtils_LIBRARY)


IF (PwrUtils_FOUND)
   set(PwrUtils_VERSION 0.0.0)
   FIND_FILE(_PwrUtils_VERSION_FILE libpwrutils/version.h ${PwrUtils_INCLUDE_DIR})
   MARK_AS_ADVANCED(_PwrUtils_VERSION_FILE)
   IF (_PwrUtils_VERSION_FILE)
      FILE(READ ${_PwrUtils_VERSION_FILE} _PwrUtils_VERSION_CONENTS)
      STRING(REGEX REPLACE ".*#define LIBPWRUTILS_VERSION \\\"([0-9.]+)\\\".*" "\\1" PwrUtils_VERSION "${_PwrUtils_VERSION_CONENTS}")
   ENDIF (_PwrUtils_VERSION_FILE)
   IF (PwrUtils_FIND_VERSION)
      IF (PwrUtils_VERSION VERSION_LESS PwrUtils_FIND_VERSION)
         IF (PwrUtils_FIND_REQUIRED)
            MESSAGE(${_PwrUtils_VERSION_FILE})
            MESSAGE(FATAL_ERROR "PwrUtils version too old: ${PwrUtils_VERSION}, requested >= ${PwrUtils_FIND_VERSION}")
         ELSE (PwrUtils_FIND_REQUIRED)
            IF (NOT PwrUtils_FIND_QUIETLY)
               MESSAGE(STATUS "PwrUtils version too old: ${PwrUtils_VERSION}, requested >= ${PwrUtils_FIND_VERSION}")
            ENDIF (NOT PwrUtils_FIND_QUIETLY)
         ENDIF (PwrUtils_FIND_REQUIRED)
         set(PwrUtils_FOUND False)
      ENDIF (PwrUtils_VERSION VERSION_LESS PwrUtils_FIND_VERSION)
   ENDIF (PwrUtils_FIND_VERSION)
   IF (NOT PwrUtils_FIND_QUIETLY)
      MESSAGE(STATUS "Found libpwrutils ${PwrUtils_VERSION}: ${PwrUtils_LIBRARY}")
   ENDIF (NOT PwrUtils_FIND_QUIETLY)
ELSE (PwrUtils_FOUND)
   IF (PwrUtils_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find libpwrutils")
   ELSE (PwrUtils_FIND_REQUIRED)
      MESSAGE(STATUS "libpwrutils not found")
   ENDIF (PwrUtils_FIND_REQUIRED)
ENDIF (PwrUtils_FOUND)
