#include <libwccl/ops/functions/bool/predicate.h>

namespace Wccl {

Predicate::RetValPtr Predicate::True(const FunExecContext& context)
{
	static Constant<Bool> true_constant(Bool(true));
	return true_constant.apply(context);
}

Predicate::RetValPtr Predicate::False(const FunExecContext& context)
{
	static Constant<Bool> false_constant(Bool(false));
	return false_constant.apply(context);
}

Predicate::RetValPtr Predicate::evaluate(bool condition, const FunExecContext &context)
{
	return condition ? True(context) : False(context);
}

} /* end ns Wccl */
