#ifndef LIBWCCL_OPS_EXPRESSION_H
#define LIBWCCL_OPS_EXPRESSION_H

#include <libcorpus2/tagset.h>
#include <boost/noncopyable.hpp>

namespace Wccl {

/**
 * Abstract base class for WCCL expressions
 */
class Expression : boost::noncopyable
{
public:
	/**
	 * @returns String representation of the expression.
	 */
	virtual std::string to_string(const Corpus2::Tagset& tagset) const = 0;
	/**
	 * @returns String representation of the expression that does not
	 * require a tagset.
	 * @note Might be incomplete and/or contain internal info.
	 */
	virtual std::string to_raw_string() const = 0;

	/**
	 * Virtual destructor, so if delete is ever called on a base-class-type
	 * of pointer, the destruction is forwarded to proper destructor
	 * in a derived class, if a special destructor was needed for that class.
	 */
	virtual ~Expression() {};
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_EXPRESSION_H
