#include <boost/test/unit_test.hpp>
#include <boost/bind.hpp>
#include <libcorpus2/tagsetmanager.h>

#include <libwccl/variables.h>

#include <iostream>

using namespace Wccl;

BOOST_AUTO_TEST_SUITE(values)

BOOST_AUTO_TEST_CASE(boolz)
{
	Bool b;
	BOOST_CHECK_EQUAL(b.get_value(), false);
	Value& v = b;
	BOOST_CHECK_EQUAL(v.get_type_name(), Bool::type_name);
}

BOOST_AUTO_TEST_CASE(tsetz)
{
	TSet t;
	BOOST_CHECK(t.get_value().is_null());
	Value& v = t;
	BOOST_CHECK_EQUAL(v.get_type_name(), TSet::type_name);
}

BOOST_AUTO_TEST_CASE(strset_ops)
{
	StrSet s1, s2;
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s1.insert_utf8("aaa");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_utf8("bbb");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_utf8("aaa");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
	s1.insert_utf8("bbb");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
}

BOOST_AUTO_TEST_CASE(tset_ops)
{
	TSet s1, s2;
	const Corpus2::Tagset& tagset = Corpus2::get_named_tagset("kipi");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s1.insert_symbol(tagset, "subst");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_symbol(tagset, "pl");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(!s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(!s1.intersects(s2));
	s2.insert_symbol(tagset, "subst");
	BOOST_CHECK(!s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(!s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
	s1.insert_symbol(tagset, "pl");
	BOOST_CHECK(s1.equals(s2));
	BOOST_CHECK(s1.is_subset_of(s2));
	BOOST_CHECK(s2.is_subset_of(s1));
	BOOST_CHECK(s1.intersects(s2));
}

BOOST_AUTO_TEST_SUITE_END()
