#ifndef LIBWCCL_OPS_PREDICATE_H
#define LIBWCCL_OPS_PREDICATE_H

#include <boost/shared_ptr.hpp>
#include <boost/scoped_ptr.hpp>

#include <libwccl/values/bool.h>
#include <libwccl/ops/functions.h>
#include <libwccl/ops/constant.h>

namespace Wccl {

/**
 * Abstract base class for Predicates (operators returning Bool)
 */
class Predicate : public Function<Bool> {
public:
	/**
	 * Constant<Bool> holding true value, to use by predicates when returning value
	 */
	static const boost::scoped_ptr< Constant<Bool> > True;
	/**
	 * Constant<Bool> holding false value, to use by predicates when returning value
	 */
	static const boost::scoped_ptr< Constant<Bool> > False;
};

} /* end ns Wccl */

#endif // LIBWCCL_OPS_PREDICATE_H
