#include <libwccl/ops/or.h>

namespace Wccl {

Or::BaseRetValPtr Or::apply_internal(const SentenceContext &context) const
{
	foreach(BoolFunctionPtr expression, *expressions_) {
		if(expression->apply(context)->get_value()) {
			return Predicate::True->apply(context);
		}
	}
	return Predicate::False->apply(context);
}

const std::string Or::raw_operator_name() const {
	return "or";
}

} /* end ns Wccl */
